/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.miniserv.client;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.montoyo.wd.miniserv.OutgoingPacket;
import net.montoyo.wd.miniserv.PacketID;
import net.montoyo.wd.miniserv.client.ClientTask;

public class ClientTaskGetFile
extends ClientTask<ClientTaskGetFile> {
    private final UUID uuid;
    private final String fname;
    private int response;
    private boolean hasResponse;
    private final ReentrantLock responseLock = new ReentrantLock();
    private final Condition gotResponse = this.responseLock.newCondition();
    private final ReentrantLock dataLock = new ReentrantLock();
    private final Condition dataChanged = this.dataLock.newCondition();
    private byte[] data;
    private int dataLen;

    public ClientTaskGetFile(UUID id, String name) {
        this.uuid = id;
        this.fname = name;
    }

    @Override
    public void start() {
        OutgoingPacket pkt = new OutgoingPacket();
        pkt.writeByte(PacketID.GET_FILE.ordinal());
        pkt.writeLong(this.uuid.getMostSignificantBits());
        pkt.writeLong(this.uuid.getLeastSignificantBits());
        pkt.writeString(this.fname);
        pkt.writeBoolean(true);
        this.client.sendPacket(pkt);
    }

    @Override
    public void abort() {
        this.responseLock.lock();
        if (!this.hasResponse) {
            this.response = 4;
            this.hasResponse = true;
            this.gotResponse.signal();
        }
        this.responseLock.unlock();
        this.onData(new byte[0], -1);
    }

    public void onGetFileResponse(int status) {
        boolean triggerError = false;
        this.responseLock.lock();
        if (this.hasResponse) {
            if (status != 0) {
                triggerError = true;
            }
        } else {
            this.response = status;
            this.hasResponse = true;
            this.gotResponse.signal();
            if (this.response != 0) {
                this.client.nextTask();
            }
        }
        this.responseLock.unlock();
        if (triggerError) {
            this.onData(new byte[0], -1);
        }
    }

    public int waitForResponse() {
        this.responseLock.lock();
        long t = System.currentTimeMillis();
        while (!this.hasResponse) {
            if (System.currentTimeMillis() - t > 10000L) {
                this.responseLock.unlock();
                this.cancel();
                return 5;
            }
            try {
                this.gotResponse.await(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.responseLock.unlock();
        return this.response;
    }

    public void onData(byte[] data, int len) {
        this.dataLock.lock();
        while (this.data != null) {
            try {
                this.dataChanged.await();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.data = data;
        this.dataLen = len;
        this.dataChanged.signal();
        this.dataLock.unlock();
        if (len <= 0) {
            this.client.nextTask();
        }
    }

    public byte[] waitForData() {
        this.dataLock.lock();
        long t = System.currentTimeMillis();
        while (this.data == null) {
            if (System.currentTimeMillis() - t > 10000L) {
                this.data = new byte[0];
                this.dataLen = -1;
                this.dataLock.unlock();
                this.cancel();
                return this.data;
            }
            try {
                this.dataChanged.await(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.dataLock.unlock();
        return this.data;
    }

    public int getDataLength() {
        return this.dataLen;
    }

    public void nextData() {
        this.dataLock.lock();
        this.data = null;
        this.dataChanged.signal();
        this.dataLock.unlock();
    }

    public String getFileName() {
        return this.fname;
    }
}

