/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.miniserv;

import java.nio.ByteBuffer;
import net.montoyo.wd.utilities.Log;

public final class PacketReader {
    private final byte[] sizeArray = new byte[4];
    private byte[] packetData;
    private int pos = 0;
    private boolean needSize = true;

    public final boolean readFrom(ByteBuffer buf) {
        if (this.needSize) {
            if (this.readByteArray(this.sizeArray, buf)) {
                int packetSize = (this.sizeArray[0] & 0xFF) << 24 | (this.sizeArray[1] & 0xFF) << 16 | (this.sizeArray[2] & 0xFF) << 8 | this.sizeArray[3] & 0xFF;
                this.needSize = false;
                this.pos = 0;
                if (packetSize < 5 || packetSize > 70000) {
                    Log.warning("Got invalid packet of size %d, things won't go well...", packetSize);
                    return true;
                }
                this.packetData = new byte[packetSize -= 4];
            } else {
                return false;
            }
        }
        return this.readByteArray(this.packetData, buf);
    }

    private boolean readByteArray(byte[] dst, ByteBuffer src) {
        int remaining = dst.length - this.pos;
        int read = src.remaining() >= remaining ? remaining : src.remaining();
        src.get(dst, this.pos, read);
        this.pos += read;
        return this.pos >= dst.length;
    }

    public final byte[] getPacketData() {
        return this.packetData;
    }

    public final void reset() {
        this.packetData = null;
        this.pos = 0;
        this.needSize = true;
    }
}

