/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.miniserv;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayDeque;
import net.montoyo.wd.miniserv.OutgoingPacket;
import net.montoyo.wd.miniserv.PacketHandler;
import net.montoyo.wd.miniserv.PacketID;
import net.montoyo.wd.miniserv.PacketReader;
import net.montoyo.wd.miniserv.PacketWriter;
import net.montoyo.wd.utilities.Log;

public abstract class AbstractClient {
    private final ByteBuffer sendBuffer = ByteBuffer.allocateDirect(8192);
    private final ArrayDeque<OutgoingPacket> sendQueue = new ArrayDeque();
    private final PacketReader packetReader = new PacketReader();
    private final PacketWriter packetWriter = new PacketWriter();
    private final Method[] packetHandlers = new Method[PacketID.values().length];
    protected SocketChannel socket;
    protected Selector selector;
    protected SelectionKey selKey;

    public AbstractClient() {
        Method[] methods;
        this.sendBuffer.limit(0);
        for (Method m : methods = this.getClass().getMethods()) {
            PacketHandler ph = m.getAnnotation(PacketHandler.class);
            if (ph == null) continue;
            if (this.packetHandlers[ph.value().ordinal()] != null) {
                Log.warning("AbstractClient: several packet handlers for %s, ignoring %s", ph.value().toString(), m.getName());
                continue;
            }
            if (m.getParameterCount() != 1 || m.getParameterTypes()[0] != DataInputStream.class) {
                Log.warning("AbstractClient: found invalid packet handler %s", m.getName());
                continue;
            }
            this.packetHandlers[ph.value().ordinal()] = m;
        }
    }

    protected abstract void onWriteError();

    public final void readyRead(ByteBuffer bb) {
        while (bb.remaining() > 0) {
            if (!this.packetReader.readFrom(bb)) continue;
            byte[] pkt = this.packetReader.getPacketData();
            if (pkt != null) {
                try {
                    DataInputStream dis = new DataInputStream(new ByteArrayInputStream(pkt));
                    int pid = dis.readByte() & 0xFF;
                    if (pid >= this.packetHandlers.length) {
                        Log.error("Caught invalid packet ID %d", pid);
                    } else if (this.packetHandlers[pid] != null) {
                        try {
                            this.packetHandlers[pid].invoke((Object)this, dis);
                        }
                        catch (IllegalAccessException ex) {
                            Log.errorEx("This shouldn't have happened", ex, new Object[0]);
                        }
                        catch (InvocationTargetException ex) {
                            Log.warningEx("Caught exception while handling packet %d", ex.getTargetException(), pid);
                        }
                    }
                }
                catch (IOException ex) {
                    Log.warningEx("IOException while trying to handle packet", ex, new Object[0]);
                }
            }
            this.packetReader.reset();
        }
        this.onDataReceived();
    }

    public final void readyWrite() throws Throwable {
        if (this.sendBuffer.remaining() > 0 || this.fillSendBuffer()) {
            int sent = this.socket.write(this.sendBuffer);
            if (sent < 0) {
                this.onWriteError();
            } else if (sent > 0) {
                this.onDataSent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fillSendBuffer() {
        this.sendBuffer.clear();
        do {
            OutgoingPacket pkt;
            if (!this.packetWriter.writeTo(this.sendBuffer)) continue;
            ArrayDeque<OutgoingPacket> arrayDeque = this.sendQueue;
            synchronized (arrayDeque) {
                pkt = this.sendQueue.poll();
                if (pkt == null) {
                    this.selKey.interestOps(1);
                    break;
                }
            }
            this.packetWriter.reset(pkt.finish());
        } while (this.sendBuffer.remaining() > 0);
        int pos = this.sendBuffer.position();
        this.sendBuffer.position(0);
        this.sendBuffer.limit(pos);
        return pos > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendPacket(OutgoingPacket pkt) {
        ArrayDeque<OutgoingPacket> arrayDeque = this.sendQueue;
        synchronized (arrayDeque) {
            this.sendQueue.offer(pkt);
            if (this.selKey.isValid() && (this.selKey.interestOps() & 4) == 0) {
                this.selKey.interestOps(5);
                this.selector.wakeup();
            }
        }
    }

    protected static String readString(DataInputStream dis) throws IOException {
        int len = dis.readShort() & 0xFFFF;
        byte[] str = new byte[len];
        dis.readFully(str);
        try {
            return new String(str, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected final byte[] getCurrentPacketRawData() {
        return this.packetReader.getPacketData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearSendQueue() {
        ArrayDeque<OutgoingPacket> arrayDeque = this.sendQueue;
        synchronized (arrayDeque) {
            this.packetWriter.clear();
            this.sendQueue.clear();
        }
    }

    protected void onDataReceived() {
    }

    protected void onDataSent() {
    }
}

