/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.renderers;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.montoyo.wd.client.renderers.ScreenModelLoader;
import net.montoyo.wd.utilities.data.BlockSide;
import net.montoyo.wd.utilities.math.Vector3f;
import net.montoyo.wd.utilities.math.Vector3i;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenBaker
implements BakedModel {
    private static final List<BakedQuad> noQuads = ImmutableList.of();
    private final TextureAtlasSprite[] texs = new TextureAtlasSprite[16];
    private final BlockSide[] blockSides = BlockSide.values();
    private final Direction[] blockFacings = Direction.values();
    private final ModelState modelState;
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ItemOverrides overrides;
    private final ItemTransforms itemTransforms;
    IntegerModelProperty[] TEXTURES = new IntegerModelProperty[6];

    public ScreenBaker(ModelState modelState, Function<Material, TextureAtlasSprite> spriteGetter, ItemOverrides overrides, ItemTransforms itemTransforms) {
        int i;
        this.modelState = modelState;
        this.spriteGetter = spriteGetter;
        this.overrides = overrides;
        this.itemTransforms = itemTransforms;
        for (i = 0; i < this.texs.length; ++i) {
            this.texs[i] = spriteGetter.apply(ScreenModelLoader.MATERIALS_SIDES[i]);
        }
        for (i = 0; i < this.TEXTURES.length; ++i) {
            this.TEXTURES[i] = new IntegerModelProperty();
        }
    }

    private void putVertex(int[] buf, int pos, Vector3f vpos, TextureAtlasSprite tex, Vector3f uv, Vector3i normal) {
        buf[pos *= 8] = Float.floatToRawIntBits(vpos.x);
        buf[pos + 1] = Float.floatToRawIntBits(vpos.y);
        buf[pos + 2] = Float.floatToRawIntBits(vpos.z);
        buf[pos + 3] = -1;
        buf[pos + 4] = Float.floatToRawIntBits(tex.m_118367_((double)uv.x));
        buf[pos + 5] = Float.floatToRawIntBits(tex.m_118393_((double)uv.y));
        int nx = normal.x * 127 & 0xFF;
        int ny = normal.y * 127 & 0xFF;
        int nz = normal.z * 127 & 0xFF;
        buf[pos + 7] = nx | ny << 8 | nz << 16;
    }

    private Vector3f rotateVec(Vector3f vec, BlockSide side) {
        return switch (side) {
            case BlockSide.BOTTOM -> new Vector3f(vec.x, 1.0f, 1.0f - vec.z);
            case BlockSide.TOP -> new Vector3f(vec.x, 0.0f, vec.z);
            case BlockSide.NORTH -> new Vector3f(vec.x, vec.z, 1.0f);
            case BlockSide.SOUTH -> new Vector3f(vec.x, 1.0f - vec.z, 0.0f);
            case BlockSide.WEST -> new Vector3f(1.0f, vec.x, vec.z);
            case BlockSide.EAST -> new Vector3f(0.0f, 1.0f - vec.x, vec.z);
            default -> throw new RuntimeException("Unknown block side " + side);
        };
    }

    private Vector3f rotateTex(BlockSide side, float u, float v) {
        return switch (side) {
            case BlockSide.BOTTOM, BlockSide.NORTH -> new Vector3f(16.0f - u, 16.0f - v, 0.0f);
            case BlockSide.TOP -> new Vector3f(16.0f - u, v, 0.0f);
            case BlockSide.SOUTH -> new Vector3f(u, v, 0.0f);
            case BlockSide.WEST -> new Vector3f(16.0f - v, u, 0.0f);
            case BlockSide.EAST -> new Vector3f(v, 16.0f - u, 0.0f);
            default -> throw new RuntimeException("Unknown block side " + side);
        };
    }

    private BakedQuad bakeSide(BlockSide side, TextureAtlasSprite tex) {
        int[] data = new int[32];
        int rotation = switch (side) {
            case BlockSide.BOTTOM, BlockSide.TOP, BlockSide.NORTH -> 2;
            case BlockSide.SOUTH -> 0;
            case BlockSide.EAST -> 1;
            case BlockSide.WEST -> 3;
            default -> throw new RuntimeException("Unknown block side " + side);
        };
        this.putVertex(data, (rotation + 3) % 4, this.rotateVec(new Vector3f(0.0f, 0.0f, 0.0f), side), tex, this.rotateTex(side, 16.0f, 0.0f), side.backward);
        this.putVertex(data, (rotation + 2) % 4, this.rotateVec(new Vector3f(0.0f, 0.0f, 1.0f), side), tex, this.rotateTex(side, 16.0f, 16.0f), side.backward);
        this.putVertex(data, (rotation + 1) % 4, this.rotateVec(new Vector3f(1.0f, 0.0f, 1.0f), side), tex, this.rotateTex(side, 0.0f, 16.0f), side.backward);
        this.putVertex(data, rotation % 4, this.rotateVec(new Vector3f(1.0f, 0.0f, 0.0f), side), tex, this.rotateTex(side, 0.0f, 0.0f), side.backward);
        return new BakedQuad(data, -1, this.blockFacings[side.ordinal()].m_122424_(), tex, true);
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource random) {
        return this.getQuads(state, side, random, ModelData.EMPTY, null);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        if (side == null) {
            return noQuads;
        }
        ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>();
        int sid = BlockSide.reverse(side.ordinal());
        BlockSide s = this.blockSides[sid];
        TextureAtlasSprite tex = this.texs[15];
        if (data.has((ModelProperty)this.TEXTURES[side.ordinal()])) {
            tex = this.texs[(Integer)data.get((ModelProperty)this.TEXTURES[side.ordinal()])];
        }
        ret.add(this.bakeSide(s, tex));
        return ret;
    }

    protected byte check(BlockState state, BlockAndTintGetter level, BlockPos pos, Vector3i dir) {
        BlockState u = level.m_8055_(pos.m_7918_(dir.x, dir.y, dir.z));
        BlockState d = level.m_8055_(pos.m_7918_(-dir.x, -dir.y, -dir.z));
        if (u.m_60734_() == state.m_60734_() && d.m_60734_() != state.m_60734_()) {
            return 1;
        }
        if (d.m_60734_() == state.m_60734_() && u.m_60734_() != state.m_60734_()) {
            return 2;
        }
        if (d.m_60734_() != state.m_60734_() && u.m_60734_() != state.m_60734_()) {
            return 3;
        }
        return 0;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        ModelData.Builder builder = ModelData.builder();
        boolean BAR_BOTTOM = true;
        int BAR_RIGHT = 2;
        int BAR_TOP = 4;
        int BAR_LEFT = 8;
        for (int i = 0; i < this.TEXTURES.length; ++i) {
            BlockSide side = this.blockSides[i];
            int res = switch (this.check(state, level, pos, side.up)) {
                case 1 -> 1;
                case 2 -> 4;
                case 3 -> 5;
                default -> 0;
            };
            builder.with((ModelProperty)this.TEXTURES[i], (Object)(res |= (switch (this.check(state, level, pos, side.right)) {
                case 1 -> 8;
                case 2 -> 2;
                case 3 -> 10;
                default -> 0;
            })));
        }
        return builder.build();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.texs[15];
    }

    @Nonnull
    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public static final class IntegerModelProperty
    extends ModelProperty<Integer> {
    }
}

