/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.controls;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.montoyo.wd.client.gui.controls.Container;
import net.montoyo.wd.client.gui.controls.Control;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;
import net.montoyo.wd.utilities.data.Bounds;

public class ControlGroup
extends Container {
    private int width;
    private int height;
    private String label;
    private int labelW;
    private int labelColor = -1;
    private boolean labelShadowed = true;

    public ControlGroup() {
        this.width = 100;
        this.height = 100;
        this.label = "";
        this.paddingX = 8;
        this.paddingY = 8;
    }

    public ControlGroup(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.paddingX = 8;
        this.paddingY = 8;
        this.label = "";
        this.labelW = 0;
    }

    public ControlGroup(int x, int y, int w, int h, String label) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.label = label;
        this.labelW = this.font.m_92895_(label);
        this.paddingX = 8;
        this.paddingY = 8;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void setLabel(String label) {
        this.label = label;
        this.labelW = this.font.m_92895_(label);
    }

    public String getLabel() {
        return this.label;
    }

    public int getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(int labelColor) {
        this.labelColor = labelColor;
    }

    public boolean isLabelShadowed() {
        return this.labelShadowed;
    }

    public void setLabelShadowed(boolean labelShadowed) {
        this.labelShadowed = labelShadowed;
    }

    @Override
    public void draw(GuiGraphics poseStack, int mouseX, int mouseY, float ptt) {
        super.draw(poseStack, mouseX, mouseY, ptt);
        if (this.visible) {
            poseStack.m_280168_().m_85836_();
            float[] sdrCol = Arrays.copyOf(RenderSystem.getShaderColor(), 4);
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            double x1 = this.x;
            double y1 = this.y;
            double x2 = this.x + this.width;
            double y2 = this.y + this.height;
            double bp = 4.0;
            double lw = this.labelW;
            x1 += bp;
            y1 += bp;
            x2 -= bp;
            y2 -= bp;
            lw += 12.0;
            this.vBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
            if (this.labelW == 0) {
                this.vBuffer.m_5483_(x1, y1 + 1.0, 0.0).m_5752_();
                this.vBuffer.m_5483_(x2, y1 + 1.0, 0.0).m_5752_();
                this.vBuffer.m_5483_(x2, y1, 0.0).m_5752_();
                this.vBuffer.m_5483_(x1, y1, 0.0).m_5752_();
            } else {
                this.vBuffer.m_5483_(x1, y1 + 1.0, 0.0).m_5752_();
                this.vBuffer.m_5483_(x1 + 8.0, y1 + 1.0, 0.0).m_5752_();
                this.vBuffer.m_5483_(x1 + 8.0, y1, 0.0).m_5752_();
                this.vBuffer.m_5483_(x1, y1, 0.0).m_5752_();
                this.vBuffer.m_5483_(x1 + lw, y1 + 1.0, 0.0).m_5752_();
                this.vBuffer.m_5483_(x2, y1 + 1.0, 0.0).m_5752_();
                this.vBuffer.m_5483_(x2, y1, 0.0).m_5752_();
                this.vBuffer.m_5483_(x1 + lw, y1, 0.0).m_5752_();
            }
            this.vBuffer.m_5483_(x1, y2, 0.0).m_5752_();
            this.vBuffer.m_5483_(x2, y2, 0.0).m_5752_();
            this.vBuffer.m_5483_(x2, y2 - 1.0, 0.0).m_5752_();
            this.vBuffer.m_5483_(x1, y2 - 1.0, 0.0).m_5752_();
            this.vBuffer.m_5483_(x1, y2, 0.0).m_5752_();
            this.vBuffer.m_5483_(x1 + 1.0, y2, 0.0).m_5752_();
            this.vBuffer.m_5483_(x1 + 1.0, y1, 0.0).m_5752_();
            this.vBuffer.m_5483_(x1, y1, 0.0).m_5752_();
            this.vBuffer.m_5483_(x2 - 1.0, y2, 0.0).m_5752_();
            this.vBuffer.m_5483_(x2, y2, 0.0).m_5752_();
            this.vBuffer.m_5483_(x2, y1, 0.0).m_5752_();
            this.vBuffer.m_5483_(x2 - 1.0, y1, 0.0).m_5752_();
            this.tessellator.m_85914_();
            RenderSystem.setShaderColor((float)sdrCol[0], (float)sdrCol[1], (float)sdrCol[2], (float)sdrCol[3]);
            RenderSystem.disableBlend();
            poseStack.m_280168_().m_85849_();
            if (this.labelW != 0) {
                poseStack.m_280056_(Minecraft.m_91087_().f_91062_, this.label, this.x + 10 + (int)bp, this.y, this.labelColor, this.labelShadowed);
            }
        }
    }

    public void pack() {
        Bounds bounds = ControlGroup.findBounds(this.childs);
        for (Control ctrl : this.childs) {
            ctrl.setPos(ctrl.getX() - bounds.minX, ctrl.getY() - bounds.minY);
        }
        this.width = bounds.getWidth() + this.paddingX * 2;
        this.height = bounds.getHeight() + this.paddingY * 2;
    }

    @Override
    public void unfocus() {
        for (Control control : this.childs) {
            control.unfocus();
        }
    }

    @Override
    public void load(JsonOWrapper json) {
        super.load(json);
        this.width = json.getInt("width", 100);
        this.height = json.getInt("height", 100);
        this.label = ControlGroup.tr(json.getString("label", ""));
        this.labelW = this.font.m_92895_(this.label);
        this.labelColor = json.getColor("labelColor", -1);
        this.labelShadowed = json.getBool("labelShadowed", true);
        if (json.getBool("pack", false)) {
            this.pack();
        }
    }
}

