/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.stream.IntStream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.montoyo.wd.utilities.Log;

@OnlyIn(value=Dist.CLIENT)
public class RenderRecipe
extends Screen {
    private static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES = new ResourceLocation("textures/gui/container/crafting_table.png");
    private static final int SIZE_X = 176;
    private static final int SIZE_Y = 166;
    private int x;
    private int y;
    private ItemRenderer renderItem;
    private final ItemStack[] recipe = new ItemStack[9];
    private ItemStack recipeResult;
    private String recipeName;
    private final ArrayList<NameRecipePair> recipes = new ArrayList();
    private ByteBuffer buffer;
    private int[] array;

    public RenderRecipe() {
        super(Component.m_130674_(null));
    }

    public void m_7856_() {
        this.x = (this.f_96543_ - 176) / 2;
        this.y = (this.f_96544_ - 166) / 2;
        this.renderItem = this.f_96541_.m_91291_();
        for (Recipe recipe : this.f_96541_.f_91073_.m_7465_().m_44051_()) {
            ResourceLocation regName = recipe.m_6423_();
            if (regName == null || !regName.m_135827_().equals("webdisplays")) continue;
            if (recipe instanceof ShapedRecipe) {
                this.recipes.add(new NameRecipePair(regName.m_135815_(), (ShapedRecipe)recipe));
                continue;
            }
            Log.warning("Found non-shaped recipe %s", regName.toString());
        }
        Log.info("Loaded %d recipes", this.recipes.size());
        this.nextRecipe();
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(context);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CRAFTING_TABLE_GUI_TEXTURES);
        Lighting.m_84930_();
        for (int sy = 0; sy < 3; ++sy) {
            for (int sx = 0; sx < 3; ++sx) {
                ItemStack is = this.recipe[sy * 3 + sx];
                if (is == null) continue;
                int x = this.x + 30 + sx * 18;
                int y = this.y + 17 + sy * 18;
                context.m_280480_(is, x, y);
                context.m_280370_(this.f_96547_, is, x, y);
            }
        }
        if (this.recipeResult != null) {
            context.m_280480_(this.recipeResult, this.x, this.y);
            context.m_280370_(this.f_96547_, this.recipeResult, this.x, this.y);
        }
        Lighting.m_84931_();
    }

    private void setRecipe(ShapedRecipe recipe) {
        IntStream.range(0, this.recipe.length).forEach(i -> {
            this.recipe[i] = null;
        });
        NonNullList ingredients = recipe.m_7527_();
        int pos = 0;
        for (int y = 0; y < recipe.getRecipeHeight(); ++y) {
            for (int x = 0; x < recipe.getRecipeWidth(); ++x) {
                ItemStack[] stacks;
                if ((stacks = ((Ingredient)ingredients.get(pos++)).m_43908_()).length <= 0) continue;
                this.recipe[y * 3 + x] = stacks[0];
            }
        }
    }

    private void nextRecipe() {
        if (this.recipes.isEmpty()) {
            this.f_96541_.m_91152_(null);
        } else {
            NameRecipePair pair = this.recipes.remove(0);
            this.setRecipe(pair.recipe);
            this.recipeName = pair.name;
        }
    }

    private int screen2DisplayX(int x) {
        double ret = (double)x / (double)this.f_96543_ * (double)this.f_96541_.m_91268_().m_85441_();
        return (int)ret;
    }

    private int screen2DisplayY(int y) {
        double ret = (double)y / (double)this.f_96544_ * (double)this.f_96541_.m_91268_().m_85442_();
        return (int)ret;
    }

    private void takeScreenshot() throws Throwable {
    }

    public void m_86600_() {
        if (this.recipeName != null) {
            try {
                this.takeScreenshot();
                this.nextRecipe();
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.f_96541_.m_91152_(null);
            }
        }
    }

    private static class NameRecipePair {
        private final String name;
        private final ShapedRecipe recipe;

        private NameRecipePair(String n, ShapedRecipe r) {
            this.name = n;
            this.recipe = r;
        }
    }
}

