/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import net.montoyo.wd.block.WDContainerBlock;
import net.montoyo.wd.core.DefaultPeripheral;
import net.montoyo.wd.entity.AbstractInterfaceBlockEntity;
import net.montoyo.wd.entity.AbstractPeripheralBlockEntity;
import net.montoyo.wd.entity.ServerBlockEntity;
import net.montoyo.wd.item.ItemLinker;
import net.montoyo.wd.net.WDNetworkRegistry;
import net.montoyo.wd.net.client_bound.S2CMessageCloseGui;
import net.montoyo.wd.utilities.Log;
import org.jetbrains.annotations.Nullable;

public class PeripheralBlock
extends WDContainerBlock {
    DefaultPeripheral type;

    public PeripheralBlock(DefaultPeripheral type) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60913_(1.5f, 10.0f));
        this.type = type;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        BlockEntityType.BlockEntitySupplier<? extends BlockEntity> cls = this.type.getTEClass();
        if (cls == null) {
            return null;
        }
        try {
            return cls.m_155267_(pos, state);
        }
        catch (Throwable t) {
            Log.errorEx("Couldn't instantiate peripheral TileEntity:", t, new Object[0]);
            return null;
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6144_()) {
            return InteractionResult.FAIL;
        }
        if (player.m_21120_(hand).m_41720_() instanceof ItemLinker) {
            return InteractionResult.FAIL;
        }
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof AbstractPeripheralBlockEntity) {
            return ((AbstractPeripheralBlockEntity)te).onRightClick(player, hand);
        }
        if (te instanceof ServerBlockEntity) {
            ((ServerBlockEntity)te).onPlayerRightClick(player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (world.f_46443_) {
            return;
        }
        if (placer instanceof Player) {
            BlockEntity te = world.m_7702_(pos);
            if (te instanceof ServerBlockEntity) {
                ((ServerBlockEntity)te).setOwner((Player)placer);
            } else if (te instanceof AbstractInterfaceBlockEntity) {
                ((AbstractInterfaceBlockEntity)te).setOwner((Player)placer);
            }
        }
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.IGNORE;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighborType, BlockPos neighbor, boolean isMoving) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof AbstractPeripheralBlockEntity) {
            ((AbstractPeripheralBlockEntity)te).onNeighborChange(neighborType, neighbor);
        }
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        if (!world.f_46443_) {
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> PeripheralBlock.point(world, pos)), (Object)new S2CMessageCloseGui(pos));
        }
        super.m_6240_(world, player, pos, state, blockEntity, tool);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        this.m_6240_(level, null, pos, level.m_8055_(pos), null, null);
    }

    public static PacketDistributor.TargetPoint point(Player exclude, Level world, BlockPos bp) {
        return new PacketDistributor.TargetPoint((ServerPlayer)exclude, (double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_(), 64.0, world.m_46472_());
    }

    public static PacketDistributor.TargetPoint point(Level world, BlockPos bp) {
        return new PacketDistributor.TargetPoint((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_(), 64.0, world.m_46472_());
    }
}

