/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon;

import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.index.CBCItems;
import rbasamoyai.createbigcannons.munitions.big_cannon.AbstractBigCannonProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.FuzedBigCannonProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.FuzedBlockEntity;
import rbasamoyai.createbigcannons.munitions.big_cannon.ProjectileBlock;
import rbasamoyai.createbigcannons.munitions.fuzes.FuzeItem;

public abstract class FuzedProjectileBlock<BLOCK_ENTITY extends FuzedBlockEntity, ENTITY extends FuzedBigCannonProjectile>
extends ProjectileBlock<ENTITY>
implements IBE<BLOCK_ENTITY> {
    protected FuzedProjectileBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static ItemStack getFuzeFromItemStack(ItemStack stack) {
        return ItemStack.m_41712_((CompoundTag)stack.m_41784_().m_128469_("BlockEntityTag").m_128469_("Fuze"));
    }

    @Override
    public AbstractBigCannonProjectile getProjectile(Level level, List<StructureTemplate.StructureBlockInfo> projectileBlocks) {
        FuzedBigCannonProjectile projectile = (FuzedBigCannonProjectile)this.getAssociatedEntityType().m_20615_(level);
        projectile.setTracer(FuzedProjectileBlock.getTracerFromBlocks(projectileBlocks));
        projectile.setFuze(FuzedProjectileBlock.getFuzeFromBlocks(projectileBlocks));
        return projectile;
    }

    @Override
    public AbstractBigCannonProjectile getProjectile(Level level, ItemStack itemStack) {
        FuzedBigCannonProjectile projectile = (FuzedBigCannonProjectile)this.getAssociatedEntityType().m_20615_(level);
        projectile.setTracer(FuzedProjectileBlock.getTracerFromItemStack(itemStack));
        projectile.setFuze(FuzedProjectileBlock.getFuzeFromItemStack(itemStack));
        return projectile;
    }

    @Override
    public AbstractBigCannonProjectile getProjectile(Level level, BlockPos pos, BlockState state) {
        FuzedBigCannonProjectile projectile = (FuzedBigCannonProjectile)this.getAssociatedEntityType().m_20615_(level);
        projectile.setTracer(FuzedProjectileBlock.getTracerFromBlock(level, pos, state));
        projectile.setFuze(FuzedProjectileBlock.getFuzeFromBlock(level, pos, state));
        return projectile;
    }

    @Override
    protected AbstractBigCannonProjectile spawnFromExplosion(Level level, BlockPos pos, BlockState state, Explosion explosion) {
        AbstractBigCannonProjectile projectile = super.spawnFromExplosion(level, pos, state, explosion);
        if (projectile instanceof FuzedBigCannonProjectile) {
            FuzedBigCannonProjectile fuzedProjectile = (FuzedBigCannonProjectile)projectile;
            fuzedProjectile.setExplosionCountdown(level.f_46441_.m_188503_(10) + 5);
        }
        return projectile;
    }

    protected static ItemStack getFuzeFromBlocks(List<StructureTemplate.StructureBlockInfo> blocks) {
        ItemStack itemStack;
        if (blocks.isEmpty()) {
            return ItemStack.f_41583_;
        }
        StructureTemplate.StructureBlockInfo info = blocks.get(0);
        if (info.f_74677_() == null) {
            return ItemStack.f_41583_;
        }
        BlockEntity load = BlockEntity.m_155241_((BlockPos)info.f_74675_(), (BlockState)info.f_74676_(), (CompoundTag)info.f_74677_());
        if (load instanceof FuzedBlockEntity) {
            FuzedBlockEntity fuzed = (FuzedBlockEntity)load;
            itemStack = fuzed.m_8020_(1);
        } else {
            itemStack = ItemStack.f_41583_;
        }
        return itemStack;
    }

    public static ItemStack getFuzeFromBlock(Level level, BlockPos pos, BlockState state) {
        ItemStack itemStack;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FuzedBlockEntity) {
            FuzedBlockEntity projectile = (FuzedBlockEntity)blockEntity;
            itemStack = projectile.getFuze();
        } else {
            itemStack = ItemStack.f_41583_;
        }
        return itemStack;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        int slot;
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        FuzedBlockEntity fuzedBlock = (FuzedBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (fuzedBlock == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        Direction fuzeFace = (Direction)state.m_61143_((Property)f_52588_);
        if (this.isBaseFuze()) {
            fuzeFace = fuzeFace.m_122424_();
        }
        if (stack.m_41619_()) {
            int slot2;
            if (!fuzedBlock.m_8020_(0).m_41619_()) {
                slot2 = 0;
            } else if (result.m_82434_() == fuzeFace && !fuzedBlock.m_8020_(1).m_41619_()) {
                slot2 = 1;
            } else {
                return InteractionResult.PASS;
            }
            if (!level.f_46443_) {
                ItemEntity item;
                ItemStack resultStack = fuzedBlock.m_7407_(slot2, 1);
                if (!player.m_36356_(resultStack) && !player.m_7500_() && (item = player.m_36176_(resultStack, false)) != null) {
                    item.m_32061_();
                    item.m_266426_(player.m_20148_());
                }
                fuzedBlock.notifyUpdate();
                if (!level.m_183326_().m_183588_(pos, (Object)this)) {
                    level.m_186460_(pos, (Block)this, 0);
                }
            }
            level.m_5594_(player, pos, SoundEvents.f_12016_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (CBCItems.TRACER_TIP.isIn(stack)) {
            slot = 0;
        } else if (stack.m_41720_() instanceof FuzeItem && result.m_82434_() == fuzeFace) {
            slot = 1;
        } else {
            return InteractionResult.PASS;
        }
        if (!fuzedBlock.m_8020_(slot).m_41619_()) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            ItemStack copy = player.m_150110_().f_35937_ ? stack.m_41777_() : stack.m_41620_(1);
            copy.m_41764_(1);
            fuzedBlock.m_6836_(slot, copy);
            fuzedBlock.notifyUpdate();
            if (!level.m_183326_().m_183588_(pos, (Object)this)) {
                level.m_186460_(pos, (Block)this, 0);
            }
        }
        level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public abstract boolean isBaseFuze();

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean isMoving) {
        if (!level.f_46443_ && !level.m_183326_().m_183588_(pos, (Object)this)) {
            level.m_186460_(pos, (Block)this, 0);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        FuzedBlockEntity fuzedBlock = (FuzedBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (fuzedBlock == null) {
            return;
        }
        ItemStack itemStack = fuzedBlock.getFuze();
        Direction[] directionArray = itemStack.m_41720_();
        if (directionArray instanceof FuzeItem) {
            FuzeItem fuze = (FuzeItem)directionArray;
            for (Direction dir : Iterate.directions) {
                int signal = level.m_277185_(pos.m_121945_(dir), dir);
                if (!fuze.onRedstoneSignal(itemStack, (Level)level, pos, state, signal, dir)) continue;
                this.detonateProjectileOnTheSpot((Level)level, pos, state, dir);
                break;
            }
        }
    }

    public void detonateProjectileOnTheSpot(Level level, BlockPos pos, BlockState state, Direction dir) {
        AbstractBigCannonProjectile projectile = this.getProjectile(level, pos, state);
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        if (!(projectile instanceof FuzedBigCannonProjectile)) {
            return;
        }
        FuzedBigCannonProjectile fuzedProjectile = (FuzedBigCannonProjectile)projectile;
        Vec3 orientation = new Vec3(dir.m_253071_());
        projectile.setOrientation(orientation);
        projectile.m_146884_(Vec3.m_82512_((Vec3i)pos));
        projectile.m_20256_(orientation.m_82490_(0.5));
        fuzedProjectile.detonate((Position)projectile.m_20182_());
    }
}

