/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.index.fluid_utils;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public abstract class CBCFlowingFluid
extends FlowingFluid {
    private final boolean infinite;
    private final Supplier<? extends Fluid> flowing;
    private final Supplier<? extends Fluid> still;
    @Nullable
    private final Supplier<? extends Item> bucket;
    @Nullable
    private final Supplier<? extends LiquidBlock> block;
    private final int dropoff;
    private final int flowspeed;
    private final int tickRate;
    private final float blastResistance;
    protected final ResourceLocation stillTex;
    protected final ResourceLocation flowingTex;
    protected final int color = -1;
    protected final SoundEvent fillSound;
    protected final SoundEvent emptySound;

    public CBCFlowingFluid(Properties properties) {
        this.infinite = properties.infinite;
        this.flowing = properties.flowing;
        this.still = properties.still;
        this.bucket = properties.bucket;
        this.block = properties.block;
        this.dropoff = properties.levelDecreasePerBlock;
        this.flowspeed = properties.flowSpeed;
        this.tickRate = properties.tickRate;
        this.blastResistance = properties.blastResistance;
        this.stillTex = properties.stillTex;
        this.flowingTex = properties.flowingTex;
        this.fillSound = properties.fillSound;
        this.emptySound = properties.emptySound;
    }

    public Fluid m_5615_() {
        return this.flowing.get();
    }

    public Fluid m_5613_() {
        return this.still.get();
    }

    protected boolean m_6760_(Level level) {
        return this.infinite;
    }

    protected void m_7456_(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.m_155947_() ? level.m_7702_(pos) : null;
        Block.m_49892_((BlockState)state, (LevelAccessor)level, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    protected int m_6719_(LevelReader level) {
        return this.flowspeed;
    }

    protected int m_6713_(LevelReader level) {
        return this.dropoff;
    }

    public Item m_6859_() {
        return this.bucket == null ? Items.f_41852_ : this.bucket.get();
    }

    protected boolean m_5486_(FluidState state, BlockGetter level, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !this.m_6212_(fluid);
    }

    public boolean m_6212_(Fluid fluid) {
        return fluid == this.m_5613_() || fluid == this.m_5615_();
    }

    public int m_6718_(LevelReader level) {
        return this.tickRate;
    }

    protected float m_6752_() {
        return this.blastResistance;
    }

    protected BlockState m_5804_(FluidState state) {
        if (this.block != null) {
            return (BlockState)this.block.get().m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(CBCFlowingFluid.m_76092_((FluidState)state)));
        }
        return Blocks.f_50016_.m_49966_();
    }

    public static class Properties {
        private Supplier<? extends Fluid> still;
        private Supplier<? extends Fluid> flowing;
        private boolean infinite;
        private Supplier<? extends Item> bucket;
        private Supplier<? extends LiquidBlock> block;
        private int flowSpeed = 4;
        private int levelDecreasePerBlock = 1;
        private float blastResistance = 1.0f;
        private int tickRate = 5;
        private final ResourceLocation stillTex;
        private final ResourceLocation flowingTex;
        private int color = 0xFFFFFF;
        private SoundEvent fillSound;
        private SoundEvent emptySound;

        public Properties(Supplier<? extends Fluid> still, Supplier<? extends Fluid> flowing, ResourceLocation stillTex, ResourceLocation flowingTex) {
            this.still = still;
            this.flowing = flowing;
            this.stillTex = stillTex;
            this.flowingTex = flowingTex;
            this.sound(SoundEvents.f_11781_, SoundEvents.f_11778_);
        }

        public Properties canMultiply() {
            this.infinite = true;
            return this;
        }

        public Properties bucket(Supplier<? extends Item> bucket) {
            this.bucket = bucket;
            return this;
        }

        public Properties block(Supplier<? extends LiquidBlock> block) {
            this.block = block;
            return this;
        }

        public Properties flowSpeed(int flowSpeed) {
            this.flowSpeed = flowSpeed;
            return this;
        }

        public Properties levelDecreasePerBlock(int levelDecreasePerBlock) {
            this.levelDecreasePerBlock = levelDecreasePerBlock;
            return this;
        }

        public Properties blastResistance(float blastResistance) {
            this.blastResistance = blastResistance;
            return this;
        }

        public Properties tickRate(int tickRate) {
            this.tickRate = tickRate;
            return this;
        }

        public Properties color(int color) {
            this.color = color;
            return this;
        }

        public Properties sound(SoundEvent sound) {
            return this.sound(sound, sound);
        }

        public Properties sound(SoundEvent fill, SoundEvent empty) {
            this.fillSound = fill;
            this.emptySound = empty;
            return this;
        }
    }

    public static class Still
    extends CBCFlowingFluid {
        public Still(Properties properties) {
            super(properties);
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }

        public int m_7430_(FluidState state) {
            return 8;
        }
    }

    public static class Flowing
    extends CBCFlowingFluid {
        public Flowing(Properties properties) {
            super(properties);
            this.m_76142_((FluidState)((FluidState)this.m_76144_().m_61090_()).m_61124_((Property)f_75948_, (Comparable)Integer.valueOf(7)));
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }
    }
}

