/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.effects.particles.explosions;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import rbasamoyai.createbigcannons.CBCClientCommon;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.effects.particles.explosions.CannonBlastWaveEffectParticleData;
import rbasamoyai.createbigcannons.effects.particles.explosions.ShellBlastWaveEffectParticleData;
import rbasamoyai.createbigcannons.effects.sounds.AirAbsorptionWrapper;
import rbasamoyai.ritchiesprojectilelib.effects.screen_shake.ScreenShakeEffect;

public class BlastWaveEffectParticle
extends NoRenderParticle {
    private final double blastRadius;
    private final SoundEvent soundEvent;
    private final SoundSource soundSource;
    private final float volume;
    private final float pitch;
    private final float airAbsorption;
    private final float shakePower;
    private final float shakeLimit;
    private final double functionalRadius;
    private double currentRadius;

    BlastWaveEffectParticle(ClientLevel level, double x, double y, double z, double blastRadius, SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch, float airAbsorption, float shakePower, float shakeLimit) {
        super(level, x, y, z);
        this.blastRadius = blastRadius;
        this.soundEvent = soundEvent;
        this.soundSource = soundSource;
        this.volume = volume;
        this.pitch = pitch;
        this.airAbsorption = airAbsorption;
        this.shakePower = shakePower;
        this.shakeLimit = shakeLimit;
        this.functionalRadius = Math.max(this.blastRadius, (double)(this.volume * 16.0f));
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107226_ = 0.0f;
    }

    public void m_5989_() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            this.m_107274_();
            return;
        }
        boolean instant = CBCConfigs.client().isInstantaneousBlastEffect();
        if (instant) {
            this.currentRadius = 0.0;
        }
        double speed = (double)CBCConfigs.client().blastEffectDelaySpeed.getF() * 0.05;
        double newRadius = instant ? this.functionalRadius : Math.min(this.currentRadius + speed, this.functionalRadius);
        double dist = Math.sqrt(minecraft.f_91074_.m_20275_(this.f_107212_, this.f_107213_, this.f_107214_));
        if (this.currentRadius <= dist && dist <= newRadius) {
            double volumeDist;
            if (dist < this.blastRadius && this.blastRadius > 0.1) {
                float f = 1.0f - (float)(dist / this.blastRadius);
                float f2 = f * f;
                float shake = Math.min(this.shakeLimit, this.shakePower * f2);
                CBCClientCommon.shakeScreenOnClient(new ScreenShakeEffect(0, shake, shake * 0.5f, shake * 0.5f, 1.0f, 1.0f, 1.0f, this.f_107212_, this.f_107213_, this.f_107214_));
            }
            if (dist < (volumeDist = (double)(this.volume * 16.0f))) {
                Object sound = new SimpleSoundInstance(this.soundEvent, this.soundSource, this.volume, this.pitch, RandomSource.m_216335_((long)this.f_107208_.f_46441_.m_188505_()), this.f_107212_, this.f_107213_, this.f_107214_);
                if (((Boolean)CBCConfigs.client().blastSoundAirAbsorption.get()).booleanValue()) {
                    sound = new AirAbsorptionWrapper((SoundInstance)sound, this.airAbsorption);
                }
                minecraft.m_91106_().m_120367_((SoundInstance)sound);
            }
            this.m_107274_();
            return;
        }
        if (instant || newRadius >= this.functionalRadius) {
            this.m_107274_();
        } else {
            this.currentRadius = newRadius;
            super.m_5989_();
        }
    }

    public static class ShellBlastProvider
    implements ParticleProvider<ShellBlastWaveEffectParticleData> {
        public Particle createParticle(ShellBlastWaveEffectParticleData type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            float power = type.power() * CBCConfigs.client().shellShakePowerMultiplier.getF();
            BlastWaveEffectParticle particle = new BlastWaveEffectParticle(level, x, y, z, type.blastRadius(), (SoundEvent)type.soundEvent().m_203334_(), type.soundSource(), type.volume(), type.pitch(), type.airAbsorption(), power, CBCConfigs.client().shellShakePowerLimit.getF());
            particle.m_107257_(100);
            return particle;
        }
    }

    public static class CannonBlastProvider
    implements ParticleProvider<CannonBlastWaveEffectParticleData> {
        public Particle createParticle(CannonBlastWaveEffectParticleData type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            float power = type.power() * CBCConfigs.client().bigCannonShakePowerMultiplier.getF();
            BlastWaveEffectParticle particle = new BlastWaveEffectParticle(level, x, y, z, type.blastRadius(), (SoundEvent)type.soundEvent().m_203334_(), type.soundSource(), type.volume(), type.pitch(), type.airAbsorption(), power, CBCConfigs.client().bigCannonShakePowerLimit.getF());
            particle.m_107257_(100);
            return particle;
        }
    }
}

