/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.autocannon.recoil_spring;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.AnimatedAutocannon;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBlockEntity;

public class AutocannonRecoilSpringBlockEntity
extends AutocannonBlockEntity
implements AnimatedAutocannon {
    public Map<BlockPos, BlockState> toAnimate = new HashMap<BlockPos, BlockState>();
    private int animateTicks = 5;

    public AutocannonRecoilSpringBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        super.tick();
        this.allTick();
    }

    @Override
    public void tickFromContraption(Level level, PitchOrientedContraptionEntity poce, BlockPos localPos) {
        BlockEntity blockEntity;
        super.tickFromContraption(level, poce, localPos);
        this.allTick();
        if (level.f_46443_ && (blockEntity = poce.getContraption().getBlockEntityClientSide(localPos)) instanceof AutocannonRecoilSpringBlockEntity) {
            AutocannonRecoilSpringBlockEntity cbe = (AutocannonRecoilSpringBlockEntity)blockEntity;
            cbe.allTick();
        }
    }

    private void allTick() {
        if (this.animateTicks < 5) {
            ++this.animateTicks;
        }
        if (this.animateTicks < 0) {
            this.animateTicks = 0;
        }
    }

    public void handleFiring() {
        this.animateTicks = 0;
    }

    public float getAnimateOffset(float partialTicks) {
        float t = ((float)this.animateTicks + partialTicks) * 1.2f;
        if (t <= 0.0f || t >= 4.8f) {
            return 1.0f;
        }
        float f = t < 1.0f ? t : (4.8f - t) / 3.8f;
        return Mth.m_14089_((float)(f * 1.5707964f));
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128405_("AnimateTicks", this.animateTicks);
        ListTag renderedList = new ListTag();
        for (Map.Entry<BlockPos, BlockState> entry : this.toAnimate.entrySet()) {
            CompoundTag block = new CompoundTag();
            block.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)entry.getKey()));
            block.m_128365_("Block", (Tag)NbtUtils.m_129202_((BlockState)entry.getValue()));
            renderedList.add((Object)block);
        }
        tag.m_128365_("RenderedBlocks", (Tag)renderedList);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.animateTicks = tag.m_128451_("AnimateTicks");
        this.toAnimate.clear();
        ListTag renderedList = tag.m_128437_("RenderedBlocks", 10);
        for (int i = 0; i < renderedList.size(); ++i) {
            CompoundTag block = renderedList.m_128728_(i);
            this.toAnimate.put(NbtUtils.m_129239_((CompoundTag)block.m_128469_("Pos")), NbtUtils.m_247651_((HolderGetter)this.blockHolderGetter(), (CompoundTag)block.m_128469_("Block")));
        }
    }

    @Override
    public void incrementAnimationTicks() {
        ++this.animateTicks;
    }

    @Override
    public int getAnimationTicks() {
        return this.animateTicks;
    }
}

