/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.cannon_mount;

import com.mojang.math.Axis;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.KineticDebugger;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.index.CBCBlockPartials;

public class CannonMountVisual
extends KineticBlockEntityVisual<CannonMountBlockEntity>
implements SimpleDynamicVisual {
    private final OrientedInstance rotatingMount;
    private final OrientedInstance rotatingMountShaft;
    private final RotatingInstance pitchShaft;
    private final RotatingInstance yawShaft;

    public CannonMountVisual(VisualizationContext ctx, CannonMountBlockEntity tile, float partialTick) {
        super(ctx, (KineticBlockEntity)tile, partialTick);
        Direction vertical = (Direction)tile.m_58900_().m_61143_((Property)BlockStateProperties.f_155997_);
        Direction facing = (Direction)tile.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        Direction.Axis pitchAxis = facing.m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        this.rotatingMount = ((OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)CBCBlockPartials.ROTATING_MOUNT)).createInstance()).position((Vec3i)this.getVisualPosition().m_121945_(vertical.m_122424_()));
        this.rotatingMountShaft = ((OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)CBCBlockPartials.CANNON_CARRIAGE_AXLE)).createInstance()).position((Vec3i)this.getVisualPosition().m_5484_(vertical, -2));
        this.pitchShaft = ((RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstance()).rotateToFace(pitchAxis).setup(((CannonMountBlockEntity)this.blockEntity).getPitchInterface()).setColor(((CannonMountBlockEntity)this.blockEntity).getPitchInterface()).setPosition((Vec3i)this.getVisualPosition());
        this.yawShaft = ((RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF)).createInstance()).rotateToFace(Direction.Axis.Z).setup(((CannonMountBlockEntity)this.blockEntity).getYawInterface()).setColor(((CannonMountBlockEntity)this.blockEntity).getYawInterface()).setPosition((Vec3i)this.getVisualPosition());
        this.transformModels();
    }

    public void _delete() {
        this.rotatingMount.delete();
        this.rotatingMountShaft.delete();
        this.pitchShaft.delete();
        this.yawShaft.delete();
    }

    private void transformModels() {
        Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        Direction.Axis pitchAxis = facing.m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        this.updateRotation(this.pitchShaft, pitchAxis, ((CannonMountBlockEntity)this.blockEntity).getPitchSpeed(), true);
        this.updateRotation(this.yawShaft, Direction.Axis.Y, ((CannonMountBlockEntity)this.blockEntity).getYawSpeed(), false);
    }

    protected void updateRotation(RotatingInstance instance, Direction.Axis axis, float speed, boolean pitch) {
        instance.setRotationAxis(axis).setRotationOffset(CannonMountVisual.rotationOffset((BlockState)this.blockState, (Direction.Axis)axis, (Vec3i)this.pos)).setRotationalSpeed(speed * 6.0f);
        if (KineticDebugger.isActive()) {
            instance.setColor(pitch ? ((CannonMountBlockEntity)this.blockEntity).getPitchInterface() : ((CannonMountBlockEntity)this.blockEntity).getYawInterface());
        }
        instance.setChanged();
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.transformModels();
        float partialTicks = ctx.partialTick();
        boolean upsideDown = this.blockState.m_61143_((Property)BlockStateProperties.f_155997_) == Direction.UP;
        float yaw = ((CannonMountBlockEntity)this.blockEntity).getYawOffset(partialTicks);
        Quaternionf qyaw = upsideDown ? Axis.f_252403_.m_252977_(180.0f).mul((Quaternionfc)Axis.f_252436_.m_252977_(yaw)) : Axis.f_252436_.m_252977_(-yaw);
        this.rotatingMount.rotation((Quaternionfc)qyaw);
        float pitch = ((CannonMountBlockEntity)this.blockEntity).getPitchOffset(partialTicks);
        Quaternionf qpitch = upsideDown ? Axis.f_252529_.m_252977_(pitch) : Axis.f_252529_.m_252977_(-pitch);
        Quaternionf qyaw1 = new Quaternionf((Quaternionfc)qyaw);
        qyaw1.mul((Quaternionfc)qpitch);
        this.rotatingMountShaft.rotation((Quaternionfc)qyaw1);
        this.rotatingMount.setChanged();
        this.rotatingMountShaft.setChanged();
        this.pitchShaft.setChanged();
        this.yawShaft.setChanged();
    }

    public void updateLight(float partialTicks) {
        Direction vertical = ((Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_155997_)).m_122424_();
        this.relight(this.pos.m_121945_(vertical), new FlatLit[]{this.rotatingMount});
        this.relight(this.pos.m_5484_(vertical, 2), new FlatLit[]{this.rotatingMountShaft});
        this.relight(this.pos, new FlatLit[]{this.pitchShaft});
        this.relight(this.pos, new FlatLit[]{this.yawShaft});
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept((Instance)this.rotatingMount);
        consumer.accept((Instance)this.rotatingMountShaft);
        consumer.accept((Instance)this.pitchShaft);
        consumer.accept((Instance)this.yawShaft);
    }
}

