/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.base;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.base.MaterialSet;
import com.drmangotea.tfmg.base.blocks.TFMGHorizontalDirectionalBlock;
import com.drmangotea.tfmg.base.blocks.TFMGVanillaBlockStates;
import com.drmangotea.tfmg.config.TFMGStress;
import com.drmangotea.tfmg.content.decoration.FrameBlock;
import com.drmangotea.tfmg.content.decoration.TrussBlock;
import com.drmangotea.tfmg.content.decoration.doors.TFMGSlidingDoorBlock;
import com.drmangotea.tfmg.content.decoration.encased.TFMGEncasedCogwheelBlock;
import com.drmangotea.tfmg.content.decoration.encased.TFMGEncasedShaftBlock;
import com.drmangotea.tfmg.content.decoration.flywheels.TFMGFlywheelBlock;
import com.drmangotea.tfmg.content.electricity.connection.copycat_cable.CopycatCableBlock;
import com.drmangotea.tfmg.content.electricity.lights.neon_tube.NeonTubeBlock;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.DoorMovingInteraction;
import com.simibubi.create.content.decoration.encasing.CasingConnectivity;
import com.simibubi.create.content.decoration.encasing.EncasedCTBehaviour;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorMovementBehaviour;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogCTBehaviour;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;

public class TFMGBuilderTransformers {
    public static final String[] COLORS = new String[]{"white", "blue", "light_blue", "red", "green", "lime", "pink", "magenta", "yellow", "gray", "light_gray", "brown", "cyan", "purple", "orange", "black"};

    public static <B extends TFMGSlidingDoorBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> slidingDoor(String type) {
        return b -> (BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)b.initialProperties(() -> Blocks.f_50166_).properties(p -> p.m_60999_().m_60913_(3.0f, 6.0f)).blockstate((c, p) -> {
            ModelFile bottom = AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[]{"bottom"});
            ModelFile top = AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[]{"top"});
            p.doorBlock((DoorBlock)c.get(), bottom, bottom, bottom, bottom, top, top, top, top);
        }).addLayer(() -> RenderType::m_110457_).transform(TagGen.pickaxeOnly())).onRegister(MovingInteractionBehaviour.interactionBehaviour((MovingInteractionBehaviour)new DoorMovingInteraction()))).onRegister(MovementBehaviour.movementBehaviour((MovementBehaviour)new SlidingDoorMovementBehaviour()))).tag(new TagKey[]{BlockTags.f_13103_}).tag(new TagKey[]{BlockTags.f_13095_}).tag(new TagKey[]{AllTags.AllBlockTags.NON_DOUBLE_DOOR.tag}).loot((lr, block) -> lr.m_247577_((Block)block, lr.m_247398_((Block)block))).item().tag(new TagKey[]{ItemTags.f_13179_}).tag(new TagKey[]{AllTags.AllItemTags.CONTRAPTION_CONTROLLED.tag}).model((c, p) -> p.blockSprite((NonNullSupplier)c, p.modLoc("item/" + type + "_door"))).build();
    }

    public static void generateNeonTubeBlockState(DataGenContext<Block, NeonTubeBlock> c, RegistrateBlockstateProvider p) {
        MultiPartBlockStateBuilder builder = p.getMultipartBuilder((Block)c.get());
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(AssetLookup.partialBaseModel(c, (RegistrateBlockstateProvider)p, (String[])new String[]{"center"})).addModel()).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(AssetLookup.partialBaseModel(c, (RegistrateBlockstateProvider)p, (String[])new String[]{"north"})).addModel()).condition((Property)PipeBlock.f_55148_, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(AssetLookup.partialBaseModel(c, (RegistrateBlockstateProvider)p, (String[])new String[]{"south"})).addModel()).condition((Property)PipeBlock.f_55150_, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(AssetLookup.partialBaseModel(c, (RegistrateBlockstateProvider)p, (String[])new String[]{"west"})).addModel()).condition((Property)PipeBlock.f_55151_, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(AssetLookup.partialBaseModel(c, (RegistrateBlockstateProvider)p, (String[])new String[]{"east"})).addModel()).condition((Property)PipeBlock.f_55149_, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(AssetLookup.partialBaseModel(c, (RegistrateBlockstateProvider)p, (String[])new String[]{"top"})).addModel()).condition((Property)PipeBlock.f_55152_, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(AssetLookup.partialBaseModel(c, (RegistrateBlockstateProvider)p, (String[])new String[]{"bottom"})).addModel()).condition((Property)PipeBlock.f_55153_, (Comparable[])new Boolean[]{true}).end();
    }

    public static <B extends TFMGEncasedShaftBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> encasedShaft(String casing, Supplier<CTSpriteShiftEntry> casingShift) {
        return builder -> (BlockBuilder)((BlockBuilder)((BlockBuilder)TFMGBuilderTransformers.encasedBase(builder, () -> ((BlockEntry)AllBlocks.SHAFT).get()).onRegister(CreateRegistrate.connectedTextures(() -> TFMGBuilderTransformers.lambda$encasedShaft$7((Supplier)casingShift)))).onRegister(CreateRegistrate.casingConnectivity((arg_0, arg_1) -> TFMGBuilderTransformers.lambda$encasedShaft$9((Supplier)casingShift, arg_0, arg_1)))).blockstate((c, p) -> BlockStateGen.axisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, blockState -> p.models().getExistingFile(p.modLoc("block/encased_shaft/block_" + casing)), (boolean)true)).item().model(AssetLookup.customBlockItemModel((String[])new String[]{"encased_shaft", "item_" + casing})).build();
    }

    public static <B extends TFMGEncasedCogwheelBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> encasedCogwheel(String casing, Supplier<CTSpriteShiftEntry> casingShift) {
        return b -> TFMGBuilderTransformers.encasedCogwheelBase(b, casing, casingShift, () -> ((BlockEntry)AllBlocks.COGWHEEL).get(), false);
    }

    public static <B extends TFMGEncasedCogwheelBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> encasedLargeCogwheel(String casing, Supplier<CTSpriteShiftEntry> casingShift) {
        return b -> (BlockBuilder)TFMGBuilderTransformers.encasedCogwheelBase(b, casing, casingShift, () -> ((BlockEntry)AllBlocks.LARGE_COGWHEEL).get(), true).onRegister(CreateRegistrate.connectedTextures(() -> TFMGBuilderTransformers.lambda$encasedLargeCogwheel$14((Supplier)casingShift)));
    }

    private static <B extends TFMGEncasedCogwheelBlock, P> BlockBuilder<B, P> encasedCogwheelBase(BlockBuilder<B, P> b, String casing, Supplier<CTSpriteShiftEntry> casingShift, Supplier<ItemLike> drop, boolean large) {
        Object encasedSuffix = !large ? "_encased_cogwheel_side" + (large ? "_connected" : "") : "_encased_cogwheel_side_large";
        String blockFolder = large ? "encased_large_cogwheel" : "encased_cogwheel";
        String wood = casing.equals("steel") ? "steel_casing" : "heavy_machinery_casing";
        String gearbox = casing.equals("steel") ? "steel_gearbox" : "heavy_gearbox";
        String casing1 = casing.equals("heavy_casing") ? "heavy_machinery" : casing;
        return (BlockBuilder)((BlockBuilder)TFMGBuilderTransformers.encasedBase(b, drop).addLayer(() -> RenderType::m_110457_).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, (CTSpriteShiftEntry)casingShift.get(), (s, f) -> f.m_122434_() == s.m_61143_((Property)TFMGEncasedCogwheelBlock.AXIS) && (Boolean)s.m_61143_((Property)(f.m_122421_() == Direction.AxisDirection.POSITIVE ? TFMGEncasedCogwheelBlock.TOP_SHAFT : TFMGEncasedCogwheelBlock.BOTTOM_SHAFT)) == false)))).blockstate((arg_0, arg_1) -> TFMGBuilderTransformers.lambda$encasedCogwheelBase$20(blockFolder, casing1, gearbox, wood, (String)encasedSuffix, arg_0, arg_1)).item().model((arg_0, arg_1) -> TFMGBuilderTransformers.lambda$encasedCogwheelBase$21(blockFolder, casing1, wood, (String)encasedSuffix, arg_0, arg_1)).build();
    }

    private static <B extends RotatedPillarKineticBlock, P> BlockBuilder<B, P> encasedBase(BlockBuilder<B, P> b, Supplier<ItemLike> drop) {
        return ((BlockBuilder)b.initialProperties(SharedProperties::stone).properties(BlockBehaviour.Properties::m_60955_).transform(TFMGStress.setNoImpact())).loot((p, lb) -> p.m_246125_((Block)lb, (ItemLike)drop.get()));
    }

    public static <B extends CopycatCableBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> copycatCable() {
        return b -> (BlockBuilder)b.initialProperties(SharedProperties::softMetal).blockstate((c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)p.models().getExistingFile(p.mcLoc("air")))).initialProperties(SharedProperties::softMetal).properties(BlockBehaviour.Properties::m_60955_).addLayer(() -> RenderType::m_110451_).addLayer(() -> RenderType::m_110463_).addLayer(() -> RenderType::m_110457_).color(() -> CopycatCableBlock::wrappedColor).transform(TagGen.axeOrPickaxe());
    }

    public static BlockEntry<TFMGFlywheelBlock> flywheel(String name, NonNullFunction<BlockBehaviour.Properties, TFMGFlywheelBlock> block) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)TFMG.REGISTRATE.block(name + "_flywheel", block).initialProperties(SharedProperties::softMetal).properties(BlockBehaviour.Properties::m_60955_).transform(TagGen.axeOrPickaxe())).transform(TFMGStress.setNoImpact())).blockstate(BlockStateGen.axisBlockProvider((boolean)true)).item().transform(ModelGen.customItemModel())).register();
    }

    public static BlockEntry<TrussBlock> truss(String name) {
        return ((BlockBuilder)((BlockBuilder)TFMG.REGISTRATE.block(name + "_truss", TrussBlock::new).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60955_()).properties(p -> p.m_60918_(SoundType.f_56725_)).transform(TagGen.pickaxeOnly())).addLayer(() -> RenderType::m_110457_).blockstate(BlockStateGen.axisBlockProvider((boolean)false)).item().build()).register();
    }

    public static BlockEntry<FrameBlock> frame(String name) {
        return ((BlockBuilder)TFMG.REGISTRATE.block(name + "_frame", FrameBlock::new).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60918_(SoundType.f_56725_)).properties(p -> p.m_60978_(3.0f)).transform(TagGen.pickaxeOnly())).addLayer(() -> RenderType::m_110457_).properties(BlockBehaviour.Properties::m_60955_).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), AssetLookup.partialBaseModel((DataGenContext)ctx, (RegistrateBlockstateProvider)prov, (String[])new String[0]))).simpleItem().register();
    }

    public static void generateCautionBlocks() {
        for (String color : COLORS) {
            String light;
            String colorWithoutC;
            if (Objects.equals(color, "black")) continue;
            String firstLetter = color.substring(0, 1).toUpperCase();
            String upperCaseColor = firstLetter + (colorWithoutC = color.substring(1));
            if (upperCaseColor.contains(light = "Light")) {
                String nameWithoutLight = upperCaseColor.substring(6);
                String firstLetter2 = nameWithoutLight.substring(0, 1).toUpperCase();
                String colorWithoutC2 = nameWithoutLight.substring(1);
                upperCaseColor = light + " " + firstLetter2 + colorWithoutC2;
            }
            ((BlockBuilder)((BlockBuilder)TFMG.REGISTRATE.block(color + "_caution_block", TFMGHorizontalDirectionalBlock::new).initialProperties(() -> Blocks.f_152504_).properties(p -> p.m_60999_()).properties(p -> p.m_60918_(SoundType.f_56725_)).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> p.horizontalBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName(), p.modLoc("block/caution_block"))).texture("0", p.modLoc("block/caution_block/" + color))).texture("particle", p.modLoc("block/caution_block/" + color)))).tag(new TagKey[]{BlockTags.f_144286_}).recipe((c, p) -> p.stonecutting(DataIngredient.tag((TagKey)AllTags.forgeItemTag((String)"ingots/aluminum")), RecipeCategory.BUILDING_BLOCKS, () -> ((DataGenContext)c).get(), 2)).item().build()).lang(upperCaseColor + " Caution Block").register();
        }
    }

    public static MaterialSet generateConcrete(boolean rebar) {
        String name = rebar ? "rebar_concrete" : "concrete";
        MaterialSet concrete = new MaterialSet();
        concrete.wall = ((BlockBuilder)((ItemBuilder)((BlockBuilder)TFMG.REGISTRATE.block(name + "_wall", WallBlock::new).initialProperties(() -> Blocks.f_50069_).properties(p -> p.m_60999_()).properties(p -> p.m_60913_(rebar ? 12.0f : 3.5f, rebar ? 1200.0f : 3.5f)).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> TFMGVanillaBlockStates.generateWallBlockState((DataGenContext<Block, WallBlock>)c, p, "concrete")).tag(new TagKey[]{BlockTags.f_144286_}).tag(new TagKey[]{BlockTags.f_13032_}).recipe((c, p) -> p.stonecutting(DataIngredient.items((ItemLike)((Block)concrete.block.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, () -> ((DataGenContext)c).get(), 1)).item().transform(b -> TFMGVanillaBlockStates.transformWallItem((ItemBuilder<BlockItem, BlockBuilder<WallBlock, CreateRegistrate>>)b, "concrete"))).build()).register();
        concrete.stairs = ((BlockBuilder)((BlockBuilder)TFMG.REGISTRATE.block(name + "_stairs", p -> new StairBlock(() -> ((Block)concrete.block.get()).m_49966_(), p)).initialProperties(() -> Blocks.f_50069_).properties(p -> p.m_60999_()).properties(p -> p.m_60913_(rebar ? 12.0f : 3.5f, rebar ? 1200.0f : 3.5f)).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> TFMGVanillaBlockStates.generateStairBlockState((DataGenContext<Block, StairBlock>)c, p, "concrete")).tag(new TagKey[]{BlockTags.f_144286_}).tag(new TagKey[]{BlockTags.f_13030_}).recipe((c, p) -> p.stonecutting(DataIngredient.items((ItemLike)((Block)concrete.block.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, () -> ((DataGenContext)c).get(), 1)).item().transform(ModelGen.customItemModel((String[])new String[]{"concrete_stairs"}))).register();
        concrete.block = ((BlockBuilder)((BlockBuilder)TFMG.REGISTRATE.block(name, Block::new).initialProperties(() -> Blocks.f_50069_).properties(p -> p.m_60913_(rebar ? 12.0f : 3.5f, rebar ? 1200.0f : 3.5f)).properties(p -> p.m_60999_()).transform(TagGen.pickaxeOnly())).blockstate(BlockStateGen.simpleCubeAll((String)"concrete")).tag(new TagKey[]{BlockTags.f_144286_}).item().build()).register();
        concrete.slab = ((BlockBuilder)((BlockBuilder)TFMG.REGISTRATE.block(name + "_slab", SlabBlock::new).initialProperties(() -> Blocks.f_50069_).properties(p -> p.m_60913_(rebar ? 12.0f : 3.5f, rebar ? 1200.0f : 3.5f)).properties(p -> p.m_60999_()).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> TFMGVanillaBlockStates.generateSlabBlockState((DataGenContext<Block, SlabBlock>)c, p, "concrete")).tag(new TagKey[]{BlockTags.f_144286_}).tag(new TagKey[]{BlockTags.f_13031_}).recipe((c, p) -> p.stonecutting(DataIngredient.items((ItemLike)((Block)concrete.block.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, () -> ((DataGenContext)c).get(), 2)).item().transform(ModelGen.customItemModel((String[])new String[]{"concrete_bottom"}))).register();
        return concrete;
    }

    public static Map<String, MaterialSet> generateColoredConcrete(boolean rebar) {
        String name = rebar ? "_rebar_concrete" : "_concrete";
        HashMap<String, MaterialSet> list = new HashMap<String, MaterialSet>();
        for (String color : COLORS) {
            MaterialSet set = new MaterialSet();
            set.block = ((BlockBuilder)((BlockBuilder)TFMG.REGISTRATE.block(color + name, Block::new).initialProperties(() -> Blocks.f_50069_).properties(p -> p.m_60913_(rebar ? 12.0f : 3.5f, rebar ? 1200.0f : 3.5f)).properties(p -> p.m_60999_()).transform(TagGen.pickaxeOnly())).blockstate(BlockStateGen.simpleCubeAll((String)(color + "_concrete"))).tag(new TagKey[]{BlockTags.f_144286_}).item().build()).register();
            set.wall = ((BlockBuilder)((ItemBuilder)((BlockBuilder)TFMG.REGISTRATE.block(color + name + "_wall", WallBlock::new).initialProperties(() -> Blocks.f_50069_).properties(p -> p.m_60913_(rebar ? 12.0f : 3.5f, rebar ? 1200.0f : 3.5f)).properties(p -> p.m_60999_()).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> TFMGVanillaBlockStates.generateWallBlockState((DataGenContext<Block, WallBlock>)c, p, color + "_concrete")).tag(new TagKey[]{BlockTags.f_144286_}).tag(new TagKey[]{BlockTags.f_13032_}).recipe((c, p) -> p.stonecutting(DataIngredient.items((ItemLike)set.block.m_5456_(), (ItemLike[])new Item[0]), RecipeCategory.BUILDING_BLOCKS, () -> ((DataGenContext)c).get(), 1)).item().transform(b -> TFMGVanillaBlockStates.transformWallItem((ItemBuilder<BlockItem, BlockBuilder<WallBlock, CreateRegistrate>>)b, color + "_concrete"))).build()).register();
            set.stairs = ((BlockBuilder)((BlockBuilder)TFMG.REGISTRATE.block(color + name + "_stairs", p -> new StairBlock(() -> ((Block)TFMGBlocks.CONCRETE.block.get()).m_49966_(), p)).initialProperties(() -> Blocks.f_50069_).properties(p -> p.m_60913_(rebar ? 12.0f : 3.5f, rebar ? 1200.0f : 3.5f)).properties(p -> p.m_60999_()).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> TFMGVanillaBlockStates.generateStairBlockState((DataGenContext<Block, StairBlock>)c, p, color + "_concrete")).tag(new TagKey[]{BlockTags.f_144286_}).tag(new TagKey[]{BlockTags.f_13030_}).recipe((c, p) -> p.stonecutting(DataIngredient.items((ItemLike)set.block.m_5456_(), (ItemLike[])new Item[0]), RecipeCategory.BUILDING_BLOCKS, () -> ((DataGenContext)c).get(), 1)).item().transform(ModelGen.customItemModel((String[])new String[]{color + "_concrete_stairs"}))).register();
            set.slab = ((BlockBuilder)((BlockBuilder)TFMG.REGISTRATE.block(color + name + "_slab", SlabBlock::new).initialProperties(() -> Blocks.f_50069_).properties(p -> p.m_60913_(rebar ? 12.0f : 3.5f, rebar ? 1200.0f : 3.5f)).properties(p -> p.m_60999_()).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> TFMGVanillaBlockStates.generateSlabBlockState((DataGenContext<Block, SlabBlock>)c, p, color + "_concrete")).tag(new TagKey[]{BlockTags.f_144286_}).tag(new TagKey[]{BlockTags.f_13031_}).recipe((c, p) -> p.stonecutting(DataIngredient.items((ItemLike)set.block.m_5456_(), (ItemLike[])new Item[0]), RecipeCategory.BUILDING_BLOCKS, () -> ((DataGenContext)c).get(), 2)).item().transform(ModelGen.customItemModel((String[])new String[]{color + "_concrete_bottom"}))).register();
            list.put(color, set);
        }
        return list;
    }

    public static MaterialSet makeVariants(BlockEntry<?> blockEntry) {
        return TFMGBuilderTransformers.makeVariants(blockEntry, false);
    }

    public static MaterialSet makeVariants(BlockEntry<?> blockEntry, boolean recipe) {
        MaterialSet materialSet = new MaterialSet();
        materialSet.block = blockEntry;
        String name = blockEntry.getId().toString().replace("tfmg:", "");
        ((BlockBuilder)((ItemBuilder)((BlockBuilder)TFMG.REGISTRATE.block(name + "_wall", WallBlock::new).initialProperties(() -> (Block)blockEntry.get()).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> TFMGVanillaBlockStates.generateWallBlockState((DataGenContext<Block, WallBlock>)c, p, name)).tag(new TagKey[]{BlockTags.f_144286_}).tag(new TagKey[]{BlockTags.f_13032_}).recipe((c, p) -> p.stonecutting(DataIngredient.items((ItemLike)blockEntry.m_5456_(), (ItemLike[])new Item[0]), RecipeCategory.BUILDING_BLOCKS, () -> ((DataGenContext)c).get(), 1)).item().transform(b -> TFMGVanillaBlockStates.transformWallItem((ItemBuilder<BlockItem, BlockBuilder<WallBlock, CreateRegistrate>>)b, name))).build()).register();
        ((BlockBuilder)((BlockBuilder)TFMG.REGISTRATE.block(name + "_slab", SlabBlock::new).initialProperties(() -> (Block)blockEntry.get()).properties(p -> p.m_60999_()).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> TFMGVanillaBlockStates.generateSlabBlockState((DataGenContext<Block, SlabBlock>)c, p, name)).tag(new TagKey[]{BlockTags.f_144286_}).tag(new TagKey[]{BlockTags.f_13031_}).recipe((c, p) -> p.stonecutting(DataIngredient.items((ItemLike)blockEntry.m_5456_(), (ItemLike[])new Item[0]), RecipeCategory.BUILDING_BLOCKS, () -> ((DataGenContext)c).get(), 2)).item().transform(ModelGen.customItemModel((String[])new String[]{name + "_bottom"}))).register();
        ((BlockBuilder)((BlockBuilder)TFMG.REGISTRATE.block(name + "_stairs", p -> new StairBlock(() -> ((Block)TFMGBlocks.CONCRETE.block.get()).m_49966_(), p)).initialProperties(() -> Blocks.f_50069_).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> TFMGVanillaBlockStates.generateStairBlockState((DataGenContext<Block, StairBlock>)c, p, name)).tag(new TagKey[]{BlockTags.f_144286_}).tag(new TagKey[]{BlockTags.f_13030_}).recipe((c, p) -> p.stonecutting(DataIngredient.items((ItemLike)blockEntry.m_5456_(), (ItemLike[])new Item[0]), RecipeCategory.BUILDING_BLOCKS, () -> ((DataGenContext)c).get(), 1)).item().transform(ModelGen.customItemModel((String[])new String[]{name + "_stairs"}))).register();
        return materialSet;
    }

    private static /* synthetic */ void lambda$encasedCogwheelBase$21(String blockFolder, String casing1, String wood, String encasedSuffix, DataGenContext c, RegistrateItemModelProvider p) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.withExistingParent(c.getName(), p.modLoc("block/" + blockFolder + "/item"))).texture("casing", TFMG.asResource("block/" + casing1 + "_casing"))).texture("particle", TFMG.asResource("block/" + casing1 + "_casing"))).texture("1", TFMG.asResource("block/" + wood))).texture("side", TFMG.asResource("block/" + casing1 + encasedSuffix));
    }

    private static /* synthetic */ void lambda$encasedCogwheelBase$20(String blockFolder, String casing1, String gearbox, String wood, String encasedSuffix, DataGenContext c, RegistrateBlockstateProvider p) {
        BlockStateGen.axisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, blockState -> {
            String suffix = ((Boolean)blockState.m_61143_((Property)TFMGEncasedCogwheelBlock.TOP_SHAFT) != false ? "_top" : "") + ((Boolean)blockState.m_61143_((Property)TFMGEncasedCogwheelBlock.BOTTOM_SHAFT) != false ? "_bottom" : "");
            String modelName = c.getName() + suffix;
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(modelName, p.modLoc("block/" + blockFolder + "/block" + suffix))).texture("casing", TFMG.asResource("block/" + casing1 + "_casing"))).texture("particle", TFMG.asResource("block/" + casing1 + "_casing"))).texture("4", TFMG.asResource("block/" + gearbox))).texture("1", TFMG.asResource("block/" + wood))).texture("side", TFMG.asResource("block/" + casing1 + encasedSuffix));
        }, (boolean)false);
    }

    private static /* synthetic */ ConnectedTextureBehaviour lambda$encasedLargeCogwheel$14(Supplier casingShift) {
        return new EncasedCogCTBehaviour((CTSpriteShiftEntry)casingShift.get());
    }

    private static /* synthetic */ void lambda$encasedShaft$9(Supplier casingShift, TFMGEncasedShaftBlock block, CasingConnectivity cc) {
        cc.make((Block)block, (CTSpriteShiftEntry)casingShift.get(), (s, f) -> f.m_122434_() != s.m_61143_((Property)TFMGEncasedShaftBlock.AXIS));
    }

    private static /* synthetic */ ConnectedTextureBehaviour lambda$encasedShaft$7(Supplier casingShift) {
        return new EncasedCTBehaviour((CTSpriteShiftEntry)casingShift.get());
    }
}

