/*
 * Decompiled with CFR 0.152.
 */
package com.retro.planar.voice;

import com.retro.planar.voice.PlanarVoicePlugin;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PlanarCallManager {
    private static final Map<UUID, CallSession> activeCalls = new HashMap<UUID, CallSession>();

    public static boolean startCall(UUID caller, UUID callee) {
        VoicechatServerApi api = PlanarVoicePlugin.SERVER_API;
        if (api == null) {
            System.out.println("[Planarcell] Cannot start call - Voice Chat API not available");
            return false;
        }
        VoicechatConnection callerConn = api.getConnectionOf(caller);
        VoicechatConnection calleeConn = api.getConnectionOf(callee);
        if (callerConn == null || calleeConn == null) {
            System.out.println("[Planarcell] Cannot start call - One or both players not connected to voice chat");
            return false;
        }
        String groupName = "Planarcell_Call_" + caller.toString().substring(0, 8);
        Group group = api.groupBuilder().setPersistent(false).setName(groupName).setPassword(UUID.randomUUID().toString()).setType(Group.Type.ISOLATED).build();
        if (group == null) {
            System.out.println("[Planarcell] Failed to create voice group for call");
            return false;
        }
        callerConn.setGroup(group);
        calleeConn.setGroup(group);
        CallSession session = new CallSession(caller, callee, group);
        activeCalls.put(caller, session);
        activeCalls.put(callee, session);
        System.out.println("[Planarcell] Call started between " + caller + " and " + callee);
        return true;
    }

    public static void endCall(UUID player) {
        CallSession session = activeCalls.remove(player);
        if (session == null) {
            return;
        }
        VoicechatServerApi api = PlanarVoicePlugin.SERVER_API;
        if (api == null) {
            return;
        }
        UUID otherPlayer = session.getOtherPlayer(player);
        activeCalls.remove(otherPlayer);
        VoicechatConnection conn1 = api.getConnectionOf(session.caller);
        VoicechatConnection conn2 = api.getConnectionOf(session.callee);
        if (conn1 != null) {
            conn1.setGroup(null);
        }
        if (conn2 != null) {
            conn2.setGroup(null);
        }
        System.out.println("[Planarcell] Call ended for " + player);
    }

    public static boolean isInCall(UUID player) {
        return activeCalls.containsKey(player);
    }

    public static UUID getCallPartner(UUID player) {
        CallSession session = activeCalls.get(player);
        return session != null ? session.getOtherPlayer(player) : null;
    }

    private static class CallSession {
        final UUID caller;
        final UUID callee;
        final Group group;

        CallSession(UUID caller, UUID callee, Group group) {
            this.caller = caller;
            this.callee = callee;
            this.group = group;
        }

        UUID getOtherPlayer(UUID player) {
            return player.equals(this.caller) ? this.callee : this.caller;
        }
    }
}

