/*
 * Decompiled with CFR 0.152.
 */
package com.retro.planar.station;

import com.retro.planar.Planar;
import com.retro.planar.station.BaseStation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class BaseStationManager {
    public static final int OVERWORLD_RANGE = 900;
    public static final int OVERWORLD_COVERAGE = 90;
    public static final int OVERWORLD_STATION_SPACING = 800;
    public static final int NETHER_RANGE = 100;
    public static final long NETHER_BREAK_MIN = 120000L;
    public static final long NETHER_BREAK_MAX = 300000L;
    public static final int NETHER_STATION_SPACING = 150;
    public static final int END_RANGE = 50;
    public static final int END_MAX_STATIONS = 2;
    private static final Map<String, List<BaseStation>> dimensionStations = new ConcurrentHashMap<String, List<BaseStation>>();
    private static final Map<UUID, SignalInfo> playerSignalCache = new ConcurrentHashMap<UUID, SignalInfo>();
    private static final Map<UUID, Long> netherBreakdownTimers = new ConcurrentHashMap<UUID, Long>();
    private static final Random random = new Random();

    public static List<BaseStation> getStationsForArea(ServerLevel level, BlockPos center, int loadRadius) {
        String dimension = BaseStationManager.getDimensionKey((Level)level);
        List stations = dimensionStations.computeIfAbsent(dimension, k -> new ArrayList());
        BaseStationManager.generateStationsIfNeeded(level, center, loadRadius, stations, dimension);
        return stations;
    }

    private static void generateStationsIfNeeded(ServerLevel level, BlockPos center, int loadRadius, List<BaseStation> stations, String dimension) {
        int range;
        int spacing;
        if (dimension.contains("nether")) {
            spacing = 150;
            range = 100;
        } else if (dimension.contains("end")) {
            spacing = 200;
            range = 50;
            if (stations.size() >= 2) {
                return;
            }
        } else {
            spacing = 800;
            range = 900;
        }
        int gridX = center.m_123341_() / spacing * spacing;
        int gridZ = center.m_123343_() / spacing * spacing;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                int stationX = gridX + dx * spacing;
                int stationZ = gridZ + dz * spacing;
                long seed = (long)stationX * 31L + (long)stationZ;
                Random posRandom = new Random(seed);
                int stationY = 64;
                BlockPos stationPos = new BlockPos(stationX += posRandom.nextInt(spacing / 4) - spacing / 8, stationY, stationZ += posRandom.nextInt(spacing / 4) - spacing / 8);
                UUID stationId = UUID.nameUUIDFromBytes((dimension + stationX + ":" + stationZ).getBytes());
                boolean exists = stations.stream().anyMatch(s -> s.getId().equals(stationId));
                if (exists || dimension.contains("end") && stations.size() >= 2) continue;
                BaseStation station = new BaseStation(stationId, stationPos, range, dimension);
                stations.add(station);
                Planar.LOGGER.debug("Generated base station at {} in {}", (Object)stationPos, (Object)dimension);
            }
        }
    }

    public static SignalInfo calculateSignal(ServerPlayer player) {
        long seed;
        Random coverageRandom;
        ServerLevel level = player.m_284548_();
        BlockPos playerPos = player.m_20183_();
        String dimension = BaseStationManager.getDimensionKey((Level)level);
        List<BaseStation> stations = BaseStationManager.getStationsForArea(level, playerPos, 2000);
        if (dimension.contains("nether")) {
            BaseStationManager.updateNetherBreakdowns(stations, player.m_20148_());
        }
        BaseStation nearestStation = null;
        BaseStation bestStation = null;
        int bestSignal = 0;
        double nearestDistance = Double.MAX_VALUE;
        for (BaseStation station : stations) {
            int signal;
            if (!station.getDimension().equals(dimension)) continue;
            double distance = station.getDistanceFrom(playerPos);
            if (distance < nearestDistance) {
                nearestDistance = distance;
                nearestStation = station;
            }
            if ((signal = station.getSignalStrength(playerPos)) <= bestSignal) continue;
            bestSignal = signal;
            bestStation = station;
        }
        if ((dimension.contains("overworld") || !dimension.contains("nether") && !dimension.contains("end")) && (coverageRandom = new Random(seed = (long)(playerPos.m_123341_() / 100 * 31 + playerPos.m_123343_() / 100))).nextInt(100) >= 90) {
            bestSignal = Math.max(0, bestSignal - 50);
        }
        SignalInfo info = new SignalInfo();
        info.signalStrength = bestSignal;
        info.hasSignal = bestSignal > 10;
        info.connectedStation = bestStation;
        info.nearestStation = nearestStation;
        info.nearestDistance = nearestDistance;
        info.dimension = dimension;
        if (nearestStation != null) {
            info.directionToNearest = nearestStation.getDirectionFrom(playerPos);
        }
        playerSignalCache.put(player.m_20148_(), info);
        return info;
    }

    private static void updateNetherBreakdowns(List<BaseStation> stations, UUID playerId) {
        long currentTime = System.currentTimeMillis();
        for (BaseStation station : stations) {
            if (!station.getDimension().contains("nether")) continue;
            if (station.isBroken() && station.shouldRepair()) {
                station.repair();
                Planar.LOGGER.debug("Nether station {} repaired", (Object)station.getId());
            }
            if (station.isBroken()) continue;
            Long lastCheck = netherBreakdownTimers.get(station.getId());
            if (lastCheck == null) {
                netherBreakdownTimers.put(station.getId(), currentTime);
                continue;
            }
            if (currentTime - lastCheck <= 30000L) continue;
            netherBreakdownTimers.put(station.getId(), currentTime);
            if (random.nextInt(100) >= 20) continue;
            long breakDuration = 120000L + random.nextLong(180000L);
            station.setBroken(true, breakDuration);
            Planar.LOGGER.debug("Nether station {} broken for {}ms", (Object)station.getId(), (Object)breakDuration);
        }
    }

    public static SignalInfo getCachedSignal(UUID playerId) {
        return playerSignalCache.get(playerId);
    }

    public static String getDimensionKey(Level level) {
        ResourceKey key = level.m_46472_();
        return key.m_135782_().toString();
    }

    public static void clear() {
        dimensionStations.clear();
        playerSignalCache.clear();
        netherBreakdownTimers.clear();
    }

    public static class SignalInfo {
        public int signalStrength = 0;
        public boolean hasSignal = false;
        public BaseStation connectedStation = null;
        public BaseStation nearestStation = null;
        public double nearestDistance = Double.MAX_VALUE;
        public float directionToNearest = 0.0f;
        public String dimension = "overworld";

        public boolean isEmergencyMode() {
            return !this.hasSignal && this.nearestStation != null;
        }

        public boolean isNether() {
            return this.dimension.contains("nether");
        }

        public boolean isEnd() {
            return this.dimension.contains("end");
        }
    }
}

