/*
 * Decompiled with CFR 0.152.
 */
package com.retro.planar.station;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class BaseStation {
    private final UUID id;
    private final BlockPos position;
    private final int range;
    private final String dimension;
    private long lastBreakTime = 0L;
    private boolean isBroken = false;
    private long breakDuration = 0L;

    public BaseStation(UUID id, BlockPos position, int range, String dimension) {
        this.id = id;
        this.position = position;
        this.range = range;
        this.dimension = dimension;
    }

    public UUID getId() {
        return this.id;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public int getRange() {
        return this.range;
    }

    public String getDimension() {
        return this.dimension;
    }

    public boolean isBroken() {
        return this.isBroken;
    }

    public void setBroken(boolean broken, long duration) {
        this.isBroken = broken;
        this.breakDuration = duration;
        this.lastBreakTime = System.currentTimeMillis();
    }

    public boolean shouldRepair() {
        if (!this.isBroken) {
            return false;
        }
        return System.currentTimeMillis() - this.lastBreakTime >= this.breakDuration;
    }

    public void repair() {
        this.isBroken = false;
        this.breakDuration = 0L;
    }

    public int getSignalStrength(BlockPos playerPos) {
        if (this.isBroken) {
            return 0;
        }
        double distance = Math.sqrt(playerPos.m_123331_((Vec3i)this.position));
        if (distance > (double)this.range) {
            return 0;
        }
        double ratio = 1.0 - distance / (double)this.range;
        return (int)(ratio * 100.0);
    }

    public boolean isInRange(BlockPos pos) {
        if (this.isBroken) {
            return false;
        }
        double distance = Math.sqrt(pos.m_123331_((Vec3i)this.position));
        return distance <= (double)this.range;
    }

    public float getDirectionFrom(BlockPos playerPos) {
        double dx = this.position.m_123341_() - playerPos.m_123341_();
        double dz = this.position.m_123343_() - playerPos.m_123343_();
        float angle = (float)Math.toDegrees(Math.atan2(dz, dx));
        return (angle + 360.0f) % 360.0f;
    }

    public double getDistanceFrom(BlockPos playerPos) {
        return Math.sqrt(playerPos.m_123331_((Vec3i)this.position));
    }
}

