/*
 * Decompiled with CFR 0.152.
 */
package com.retro.planar.server;

import com.retro.planar.Planar;
import com.retro.planar.network.CallManager;
import com.retro.planar.network.NetworkHandler;
import com.retro.planar.network.SignalSyncPacket;
import com.retro.planar.station.BaseStationManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="planarcell")
public class ServerEventHandler {
    private static int tickCounter = 0;
    private static final int SYNC_INTERVAL = 20;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++tickCounter >= 20) {
            tickCounter = 0;
            if (event.getServer() != null) {
                for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                    ServerEventHandler.syncSignalToPlayer(player);
                }
            }
        }
    }

    private static void syncSignalToPlayer(ServerPlayer player) {
        try {
            BaseStationManager.SignalInfo info = BaseStationManager.calculateSignal(player);
            boolean stationBroken = info.connectedStation != null && info.connectedStation.isBroken();
            SignalSyncPacket packet = new SignalSyncPacket(info.signalStrength, info.hasSignal, info.isEmergencyMode(), info.directionToNearest, info.nearestDistance, info.dimension, stationBroken);
            NetworkHandler.sendToPlayer(packet, player);
        }
        catch (Exception e) {
            Planar.LOGGER.error("Error syncing signal to player {}: {}", (Object)player.m_7755_().getString(), (Object)e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CallManager.onPlayerDisconnect(player2.m_20148_(), player2.m_20194_());
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ServerEventHandler.syncSignalToPlayer(player2);
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        BaseStationManager.clear();
    }
}

