/*
 * Decompiled with CFR 0.152.
 */
package com.retro.planar.network;

import com.retro.planar.client.gui.HUDPhoneRenderer;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class WaitingCallPacket {
    private final UUID callerUUID;
    private final String callerName;
    private final boolean isWaiting;

    public WaitingCallPacket(UUID callerUUID, String callerName, boolean isWaiting) {
        this.callerUUID = callerUUID;
        this.callerName = callerName;
        this.isWaiting = isWaiting;
    }

    public static void encode(WaitingCallPacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.callerUUID);
        buf.m_130070_(msg.callerName);
        buf.writeBoolean(msg.isWaiting);
    }

    public static WaitingCallPacket decode(FriendlyByteBuf buf) {
        return new WaitingCallPacket(buf.m_130259_(), buf.m_130277_(), buf.readBoolean());
    }

    public static void handle(WaitingCallPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            if (msg.isWaiting) {
                HUDPhoneRenderer.getInstance().showWaitingCall(msg.callerUUID, msg.callerName);
            } else {
                HUDPhoneRenderer.getInstance().clearWaitingCall(msg.callerUUID);
            }
        });
        ctx.setPacketHandled(true);
    }
}

