/*
 * Decompiled with CFR 0.152.
 */
package com.retro.planar.network;

import com.retro.planar.client.gui.HUDPhoneRenderer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SignalSyncPacket {
    private final int signalStrength;
    private final boolean hasSignal;
    private final boolean emergencyMode;
    private final float directionToNearest;
    private final double distanceToNearest;
    private final String dimension;
    private final boolean stationBroken;

    public SignalSyncPacket(int signalStrength, boolean hasSignal, boolean emergencyMode, float directionToNearest, double distanceToNearest, String dimension, boolean stationBroken) {
        this.signalStrength = signalStrength;
        this.hasSignal = hasSignal;
        this.emergencyMode = emergencyMode;
        this.directionToNearest = directionToNearest;
        this.distanceToNearest = distanceToNearest;
        this.dimension = dimension;
        this.stationBroken = stationBroken;
    }

    public static void encode(SignalSyncPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.signalStrength);
        buf.writeBoolean(msg.hasSignal);
        buf.writeBoolean(msg.emergencyMode);
        buf.writeFloat(msg.directionToNearest);
        buf.writeDouble(msg.distanceToNearest);
        buf.m_130070_(msg.dimension);
        buf.writeBoolean(msg.stationBroken);
    }

    public static SignalSyncPacket decode(FriendlyByteBuf buf) {
        return new SignalSyncPacket(buf.readInt(), buf.readBoolean(), buf.readBoolean(), buf.readFloat(), buf.readDouble(), buf.m_130277_(), buf.readBoolean());
    }

    public static void handle(SignalSyncPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> HUDPhoneRenderer.getInstance().updateSignalInfo(msg.signalStrength, msg.hasSignal, msg.emergencyMode, msg.directionToNearest, msg.distanceToNearest, msg.dimension, msg.stationBroken));
        ctx.setPacketHandled(true);
    }
}

