/*
 * Decompiled with CFR 0.152.
 */
package com.retro.planar.network;

import com.retro.planar.network.CallHoldPacket;
import com.retro.planar.network.CallRequestPacket;
import com.retro.planar.network.CallResponsePacket;
import com.retro.planar.network.CallStatusPacket;
import com.retro.planar.network.EndCallPacket;
import com.retro.planar.network.IncomingCallPacket;
import com.retro.planar.network.SignalSyncPacket;
import com.retro.planar.network.WaitingCallPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "2";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("planarcell", "main"), () -> "2", "2"::equals, "2"::equals);
    private static int packetId = 0;

    public static void register() {
        CHANNEL.registerMessage(packetId++, CallRequestPacket.class, CallRequestPacket::encode, CallRequestPacket::decode, CallRequestPacket::handle);
        CHANNEL.registerMessage(packetId++, CallResponsePacket.class, CallResponsePacket::encode, CallResponsePacket::decode, CallResponsePacket::handle);
        CHANNEL.registerMessage(packetId++, IncomingCallPacket.class, IncomingCallPacket::encode, IncomingCallPacket::decode, IncomingCallPacket::handle);
        CHANNEL.registerMessage(packetId++, CallStatusPacket.class, CallStatusPacket::encode, CallStatusPacket::decode, CallStatusPacket::handle);
        CHANNEL.registerMessage(packetId++, EndCallPacket.class, EndCallPacket::encode, EndCallPacket::decode, EndCallPacket::handle);
        CHANNEL.registerMessage(packetId++, SignalSyncPacket.class, SignalSyncPacket::encode, SignalSyncPacket::decode, SignalSyncPacket::handle);
        CHANNEL.registerMessage(packetId++, CallHoldPacket.class, CallHoldPacket::encode, CallHoldPacket::decode, CallHoldPacket::handle);
        CHANNEL.registerMessage(packetId++, WaitingCallPacket.class, WaitingCallPacket::encode, WaitingCallPacket::decode, WaitingCallPacket::handle);
    }

    public static void sendToServer(Object msg) {
        CHANNEL.sendToServer(msg);
    }

    public static void sendToPlayer(Object msg, ServerPlayer player) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), msg);
    }

    public static void sendToAll(Object msg) {
        CHANNEL.send(PacketDistributor.ALL.noArg(), msg);
    }
}

