/*
 * Decompiled with CFR 0.152.
 */
package com.retro.planar.network;

import com.retro.planar.client.gui.HUDPhoneRenderer;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class IncomingCallPacket {
    private final UUID callerUUID;
    private final String callerName;

    public IncomingCallPacket(UUID callerUUID, String callerName) {
        this.callerUUID = callerUUID;
        this.callerName = callerName;
    }

    public static void encode(IncomingCallPacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.callerUUID);
        buf.m_130070_(msg.callerName);
    }

    public static IncomingCallPacket decode(FriendlyByteBuf buf) {
        return new IncomingCallPacket(buf.m_130259_(), buf.m_130277_());
    }

    public static void handle(IncomingCallPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> HUDPhoneRenderer.getInstance().showIncomingCall(msg.callerUUID, msg.callerName));
        ctx.setPacketHandled(true);
    }
}

