/*
 * Decompiled with CFR 0.152.
 */
package com.retro.planar.network;

import com.retro.planar.network.CallManager;
import com.retro.planar.network.CallStatusPacket;
import com.retro.planar.network.NetworkHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class EndCallPacket {
    public static void encode(EndCallPacket msg, FriendlyByteBuf buf) {
    }

    public static EndCallPacket decode(FriendlyByteBuf buf) {
        return new EndCallPacket();
    }

    public static void handle(EndCallPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer heldPlayer;
            UUID heldPartner;
            ServerPlayer otherPlayer;
            ServerPlayer sender = ctx.getSender();
            if (sender == null) {
                return;
            }
            UUID otherPlayerUUID = CallManager.getCallPartner(sender.m_20148_());
            CallManager.endCall(sender.m_20148_());
            if (otherPlayerUUID != null && (otherPlayer = sender.m_20194_().m_6846_().m_11259_(otherPlayerUUID)) != null) {
                NetworkHandler.sendToPlayer(new CallStatusPacket(CallStatusPacket.Status.ENDED, sender.m_7755_().getString()), otherPlayer);
            }
            if ((heldPartner = CallManager.getHeldCallPartner(sender.m_20148_())) != null && (heldPlayer = sender.m_20194_().m_6846_().m_11259_(heldPartner)) != null) {
                NetworkHandler.sendToPlayer(new CallStatusPacket(CallStatusPacket.Status.ENDED, ""), sender);
            }
        });
        ctx.setPacketHandled(true);
    }
}

