/*
 * Decompiled with CFR 0.152.
 */
package com.retro.planar.network;

import com.retro.planar.client.gui.HUDPhoneRenderer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class CallStatusPacket {
    private final Status status;
    private final String otherPlayerName;

    public CallStatusPacket(Status status, String otherPlayerName) {
        this.status = status;
        this.otherPlayerName = otherPlayerName;
    }

    public static void encode(CallStatusPacket msg, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)msg.status);
        buf.m_130070_(msg.otherPlayerName);
    }

    public static CallStatusPacket decode(FriendlyByteBuf buf) {
        return new CallStatusPacket((Status)buf.m_130066_(Status.class), buf.m_130277_());
    }

    public static void handle(CallStatusPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> HUDPhoneRenderer.getInstance().updateCallStatus(msg.status, msg.otherPlayerName));
        ctx.setPacketHandled(true);
    }

    public static enum Status {
        RINGING,
        CONNECTED,
        BUSY,
        REJECTED,
        ENDED;

    }
}

