/*
 * Decompiled with CFR 0.152.
 */
package com.retro.planar.network;

import com.retro.planar.network.CallManager;
import com.retro.planar.network.CallStatusPacket;
import com.retro.planar.network.NetworkHandler;
import com.retro.planar.station.BaseStationManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class CallResponsePacket {
    private final UUID callerUUID;
    private final boolean accepted;

    public CallResponsePacket(UUID callerUUID, boolean accepted) {
        this.callerUUID = callerUUID;
        this.accepted = accepted;
    }

    public static void encode(CallResponsePacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.callerUUID);
        buf.writeBoolean(msg.accepted);
    }

    public static CallResponsePacket decode(FriendlyByteBuf buf) {
        return new CallResponsePacket(buf.m_130259_(), buf.readBoolean());
    }

    public static void handle(CallResponsePacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer responder = ctx.getSender();
            if (responder == null) {
                return;
            }
            ServerPlayer caller = responder.m_20194_().m_6846_().m_11259_(msg.callerUUID);
            if (msg.accepted) {
                BaseStationManager.SignalInfo responderSignal = BaseStationManager.calculateSignal(responder);
                if (!responderSignal.hasSignal) {
                    NetworkHandler.sendToPlayer(new CallStatusPacket(CallStatusPacket.Status.BUSY, "Sinyal yok!"), responder);
                    if (caller != null) {
                        NetworkHandler.sendToPlayer(new CallStatusPacket(CallStatusPacket.Status.BUSY, "Karsi taraf sinyal kaybetti"), caller);
                    }
                    CallManager.endCall(msg.callerUUID);
                    return;
                }
                CallManager.acceptCall(msg.callerUUID, responder.m_20148_());
                if (caller != null) {
                    NetworkHandler.sendToPlayer(new CallStatusPacket(CallStatusPacket.Status.CONNECTED, responder.m_7755_().getString()), caller);
                }
                NetworkHandler.sendToPlayer(new CallStatusPacket(CallStatusPacket.Status.CONNECTED, caller != null ? caller.m_7755_().getString() : ""), responder);
            } else {
                CallManager.endCall(msg.callerUUID);
                if (caller != null) {
                    NetworkHandler.sendToPlayer(new CallStatusPacket(CallStatusPacket.Status.REJECTED, responder.m_7755_().getString()), caller);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

