/*
 * Decompiled with CFR 0.152.
 */
package com.retro.planar.network;

import com.retro.planar.network.CallManager;
import com.retro.planar.network.CallStatusPacket;
import com.retro.planar.network.IncomingCallPacket;
import com.retro.planar.network.NetworkHandler;
import com.retro.planar.station.BaseStationManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class CallRequestPacket {
    private final UUID targetPlayerUUID;

    public CallRequestPacket(UUID targetPlayerUUID) {
        this.targetPlayerUUID = targetPlayerUUID;
    }

    public static void encode(CallRequestPacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.targetPlayerUUID);
    }

    public static CallRequestPacket decode(FriendlyByteBuf buf) {
        return new CallRequestPacket(buf.m_130259_());
    }

    public static void handle(CallRequestPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer caller = ctx.getSender();
            if (caller == null) {
                return;
            }
            BaseStationManager.SignalInfo callerSignal = BaseStationManager.calculateSignal(caller);
            if (!callerSignal.hasSignal) {
                NetworkHandler.sendToPlayer(new CallStatusPacket(CallStatusPacket.Status.BUSY, "Sinyal yok! Baz istasyonu arayin."), caller);
                return;
            }
            ServerPlayer target = caller.m_20194_().m_6846_().m_11259_(msg.targetPlayerUUID);
            if (target == null) {
                NetworkHandler.sendToPlayer(new CallStatusPacket(CallStatusPacket.Status.BUSY, "Cevirim disi"), caller);
                return;
            }
            BaseStationManager.SignalInfo targetSignal = BaseStationManager.calculateSignal(target);
            if (!targetSignal.hasSignal) {
                NetworkHandler.sendToPlayer(new CallStatusPacket(CallStatusPacket.Status.BUSY, "Aranan kisi kapsama alaninda degil"), caller);
                return;
            }
            CallManager.CallResult result = CallManager.startCall(caller.m_20148_(), target.m_20148_(), caller.m_20194_());
            if (!result.success) {
                NetworkHandler.sendToPlayer(new CallStatusPacket(CallStatusPacket.Status.BUSY, result.errorMessage), caller);
                return;
            }
            if (CallManager.isInActiveCall(target.m_20148_())) {
                NetworkHandler.sendToPlayer(new CallStatusPacket(CallStatusPacket.Status.RINGING, target.m_7755_().getString() + " (mesgul - beklemede)"), caller);
                return;
            }
            NetworkHandler.sendToPlayer(new CallStatusPacket(CallStatusPacket.Status.RINGING, target.m_7755_().getString()), caller);
            NetworkHandler.sendToPlayer(new IncomingCallPacket(caller.m_20148_(), caller.m_7755_().getString()), target);
        });
        ctx.setPacketHandled(true);
    }
}

