/*
 * Decompiled with CFR 0.152.
 */
package com.retro.planar.network;

import com.retro.planar.Planar;
import com.retro.planar.network.CallStatusPacket;
import com.retro.planar.network.NetworkHandler;
import com.retro.planar.network.WaitingCallPacket;
import com.retro.planar.voice.PlanarCallManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class CallManager {
    private static final Map<UUID, CallSession> activeCalls = new ConcurrentHashMap<UUID, CallSession>();
    private static final Map<UUID, CallSession> heldCalls = new ConcurrentHashMap<UUID, CallSession>();
    private static final Map<UUID, CallSession> pendingCalls = new ConcurrentHashMap<UUID, CallSession>();
    private static final Map<UUID, List<CallSession>> waitingCalls = new ConcurrentHashMap<UUID, List<CallSession>>();

    public static CallResult startCall(UUID caller, UUID target, MinecraftServer server) {
        if (CallManager.isInActiveCall(caller)) {
            return new CallResult(false, "Zaten bir gorusmede bulunuyorsunuz", null);
        }
        if (CallManager.isInActiveCall(target)) {
            CallSession waitingSession = new CallSession(caller, target, CallState.WAITING);
            waitingCalls.computeIfAbsent(target, k -> new ArrayList()).add(waitingSession);
            pendingCalls.put(caller, waitingSession);
            ServerPlayer targetPlayer = server.m_6846_().m_11259_(target);
            ServerPlayer callerPlayer = server.m_6846_().m_11259_(caller);
            if (targetPlayer != null && callerPlayer != null) {
                NetworkHandler.sendToPlayer(new WaitingCallPacket(caller, callerPlayer.m_7755_().getString(), true), targetPlayer);
            }
            return new CallResult(true, "Kullanici mesgul. Beklemede...", waitingSession);
        }
        CallSession session = new CallSession(caller, target, CallState.PENDING);
        pendingCalls.put(target, session);
        pendingCalls.put(caller, session);
        return new CallResult(true, null, session);
    }

    public static void acceptCall(UUID caller, UUID target) {
        List<CallSession> waiting;
        CallSession session = pendingCalls.remove(target);
        if (session == null && (waiting = waitingCalls.get(target)) != null && (session = (CallSession)waiting.stream().filter(s -> s.caller.equals(caller)).findFirst().orElse(null)) != null) {
            waiting.remove(session);
        }
        pendingCalls.remove(caller);
        if (session != null) {
            session.state = CallState.ACTIVE;
            session.startTime = System.currentTimeMillis();
            activeCalls.put(caller, session);
            activeCalls.put(target, session);
            try {
                PlanarCallManager.startCall(caller, target);
            }
            catch (Exception e) {
                Planar.LOGGER.warn("Failed to start voice chat group: {}", (Object)e.getMessage());
            }
        }
    }

    public static UUID endCall(UUID player) {
        CallSession pendingSession;
        CallSession heldSession;
        UUID partner = null;
        CallSession activeSession = activeCalls.remove(player);
        if (activeSession != null) {
            partner = activeSession.getOtherParty(player);
            activeCalls.remove(partner);
            try {
                PlanarCallManager.endCall(player);
            }
            catch (Exception e) {
                Planar.LOGGER.warn("Failed to end voice chat group: {}", (Object)e.getMessage());
            }
        }
        if ((heldSession = heldCalls.remove(player)) != null) {
            UUID heldPartner = heldSession.getOtherParty(player);
            heldCalls.remove(heldPartner);
            if (partner == null) {
                partner = heldPartner;
            }
        }
        if ((pendingSession = pendingCalls.remove(player)) != null) {
            UUID pendingPartner = pendingSession.getOtherParty(player);
            pendingCalls.remove(pendingPartner);
            if (partner == null) {
                partner = pendingPartner;
            }
        }
        waitingCalls.remove(player);
        for (List<CallSession> waiting : waitingCalls.values()) {
            waiting.removeIf(s -> s.involves(player));
        }
        return partner;
    }

    public static void holdCurrentCall(UUID player) {
        CallSession activeSession = activeCalls.get(player);
        if (activeSession == null) {
            return;
        }
        activeSession.state = CallState.HELD;
        activeSession.isHeld = true;
        UUID partner = activeSession.getOtherParty(player);
        try {
            PlanarCallManager.endCall(player);
        }
        catch (Exception e) {
            Planar.LOGGER.warn("Failed to leave voice chat group on hold: {}", (Object)e.getMessage());
        }
        heldCalls.put(player, activeSession);
        heldCalls.put(partner, activeSession);
        activeCalls.remove(player);
        activeCalls.remove(partner);
        Planar.LOGGER.debug("Call held between {} and {}", (Object)player, (Object)partner);
    }

    public static void resumeHeldCall(UUID player) {
        CallSession heldSession = heldCalls.get(player);
        if (heldSession == null) {
            return;
        }
        if (CallManager.isInActiveCall(player)) {
            CallManager.holdCurrentCall(player);
        }
        heldSession.state = CallState.ACTIVE;
        heldSession.isHeld = false;
        UUID partner = heldSession.getOtherParty(player);
        activeCalls.put(player, heldSession);
        activeCalls.put(partner, heldSession);
        heldCalls.remove(player);
        heldCalls.remove(partner);
        try {
            PlanarCallManager.startCall(player, partner);
        }
        catch (Exception e) {
            Planar.LOGGER.warn("Failed to rejoin voice chat group on resume: {}", (Object)e.getMessage());
        }
        Planar.LOGGER.debug("Call resumed between {} and {}", (Object)player, (Object)partner);
    }

    public static void switchToWaitingCall(UUID player, UUID callerUUID, MinecraftServer server) {
        List<CallSession> waiting = waitingCalls.get(player);
        if (waiting == null || waiting.isEmpty()) {
            return;
        }
        CallSession waitingSession = callerUUID != null ? (CallSession)waiting.stream().filter(s -> s.caller.equals(callerUUID)).findFirst().orElse(null) : waiting.get(0);
        if (waitingSession == null) {
            return;
        }
        CallManager.holdCurrentCall(player);
        waiting.remove(waitingSession);
        pendingCalls.remove(waitingSession.caller);
        waitingSession.state = CallState.ACTIVE;
        waitingSession.startTime = System.currentTimeMillis();
        activeCalls.put(player, waitingSession);
        activeCalls.put(waitingSession.caller, waitingSession);
        ServerPlayer targetPlayer = server.m_6846_().m_11259_(player);
        ServerPlayer callerPlayer = server.m_6846_().m_11259_(waitingSession.caller);
        if (callerPlayer != null) {
            NetworkHandler.sendToPlayer(new CallStatusPacket(CallStatusPacket.Status.CONNECTED, targetPlayer != null ? targetPlayer.m_7755_().getString() : ""), callerPlayer);
        }
        if (targetPlayer != null) {
            NetworkHandler.sendToPlayer(new CallStatusPacket(CallStatusPacket.Status.CONNECTED, callerPlayer != null ? callerPlayer.m_7755_().getString() : ""), targetPlayer);
            NetworkHandler.sendToPlayer(new WaitingCallPacket(waitingSession.caller, "", false), targetPlayer);
        }
        Planar.LOGGER.debug("Switched to waiting call from {}", (Object)waitingSession.caller);
    }

    public static void rejectWaitingCall(UUID player, UUID callerUUID, MinecraftServer server) {
        List<CallSession> waiting = waitingCalls.get(player);
        if (waiting == null) {
            return;
        }
        CallSession toReject = waiting.stream().filter(s -> s.caller.equals(callerUUID)).findFirst().orElse(null);
        if (toReject != null) {
            waiting.remove(toReject);
            pendingCalls.remove(callerUUID);
            ServerPlayer callerPlayer = server.m_6846_().m_11259_(callerUUID);
            if (callerPlayer != null) {
                ServerPlayer targetPlayer = server.m_6846_().m_11259_(player);
                NetworkHandler.sendToPlayer(new CallStatusPacket(CallStatusPacket.Status.REJECTED, targetPlayer != null ? targetPlayer.m_7755_().getString() : ""), callerPlayer);
            }
        }
    }

    public static boolean isInActiveCall(UUID player) {
        return activeCalls.containsKey(player);
    }

    public static boolean isInCall(UUID player) {
        return activeCalls.containsKey(player) || heldCalls.containsKey(player) || pendingCalls.containsKey(player);
    }

    public static boolean hasHeldCall(UUID player) {
        return heldCalls.containsKey(player);
    }

    public static boolean hasWaitingCalls(UUID player) {
        List<CallSession> waiting = waitingCalls.get(player);
        return waiting != null && !waiting.isEmpty();
    }

    public static List<CallSession> getWaitingCalls(UUID player) {
        return waitingCalls.getOrDefault(player, Collections.emptyList());
    }

    public static UUID getActiveCallPartner(UUID player) {
        CallSession session = activeCalls.get(player);
        return session != null ? session.getOtherParty(player) : null;
    }

    public static UUID getCallPartner(UUID player) {
        CallSession session = activeCalls.get(player);
        if (session != null) {
            return session.getOtherParty(player);
        }
        session = pendingCalls.get(player);
        if (session != null) {
            return session.getOtherParty(player);
        }
        session = heldCalls.get(player);
        if (session != null) {
            return session.getOtherParty(player);
        }
        return null;
    }

    public static UUID getHeldCallPartner(UUID player) {
        CallSession session = heldCalls.get(player);
        return session != null ? session.getOtherParty(player) : null;
    }

    public static UUID getPendingCaller(UUID target) {
        CallSession session = pendingCalls.get(target);
        if (session != null && session.target.equals(target)) {
            return session.caller;
        }
        return null;
    }

    public static boolean hasPendingOutgoingCall(UUID caller) {
        CallSession session = pendingCalls.get(caller);
        return session != null && session.caller.equals(caller);
    }

    public static void onPlayerDisconnect(UUID player, MinecraftServer server) {
        ServerPlayer partnerPlayer;
        UUID partner = CallManager.endCall(player);
        if (partner != null && server != null && (partnerPlayer = server.m_6846_().m_11259_(partner)) != null) {
            NetworkHandler.sendToPlayer(new CallStatusPacket(CallStatusPacket.Status.ENDED, "Baglanti kesildi"), partnerPlayer);
        }
    }

    public static class CallResult {
        public final boolean success;
        public final String errorMessage;
        public final CallSession session;

        public CallResult(boolean success, String errorMessage, CallSession session) {
            this.success = success;
            this.errorMessage = errorMessage;
            this.session = session;
        }
    }

    public static class CallSession {
        public final UUID caller;
        public final UUID target;
        public CallState state;
        public long startTime;
        public boolean isHeld = false;

        public CallSession(UUID caller, UUID target, CallState state) {
            this.caller = caller;
            this.target = target;
            this.state = state;
            this.startTime = System.currentTimeMillis();
        }

        public UUID getOtherParty(UUID player) {
            return player.equals(this.caller) ? this.target : this.caller;
        }

        public boolean involves(UUID player) {
            return this.caller.equals(player) || this.target.equals(player);
        }
    }

    public static enum CallState {
        PENDING,
        ACTIVE,
        HELD,
        WAITING;

    }
}

