/*
 * Decompiled with CFR 0.152.
 */
package com.retro.planar.network;

import com.retro.planar.network.CallManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class CallHoldPacket {
    private final Action action;
    private final UUID targetCallUUID;

    public CallHoldPacket(Action action) {
        this(action, null);
    }

    public CallHoldPacket(Action action, UUID targetCallUUID) {
        this.action = action;
        this.targetCallUUID = targetCallUUID;
    }

    public static void encode(CallHoldPacket msg, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)msg.action);
        buf.writeBoolean(msg.targetCallUUID != null);
        if (msg.targetCallUUID != null) {
            buf.m_130077_(msg.targetCallUUID);
        }
    }

    public static CallHoldPacket decode(FriendlyByteBuf buf) {
        Action action = (Action)buf.m_130066_(Action.class);
        UUID targetUUID = null;
        if (buf.readBoolean()) {
            targetUUID = buf.m_130259_();
        }
        return new CallHoldPacket(action, targetUUID);
    }

    public static void handle(CallHoldPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            if (sender == null) {
                return;
            }
            switch (msg.action) {
                case HOLD_CURRENT: {
                    CallManager.holdCurrentCall(sender.m_20148_());
                    break;
                }
                case RESUME_HELD: {
                    CallManager.resumeHeldCall(sender.m_20148_());
                    break;
                }
                case SWITCH_TO_WAITING: {
                    CallManager.switchToWaitingCall(sender.m_20148_(), msg.targetCallUUID, sender.m_20194_());
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static enum Action {
        HOLD_CURRENT,
        RESUME_HELD,
        SWITCH_TO_WAITING;

    }
}

