/*
 * Decompiled with CFR 0.152.
 */
package com.retro.planar.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class PhoneScreen
extends Screen {
    private static final int PHONE_WIDTH = 220;
    private static final int PHONE_HEIGHT = 400;
    private static final int MENU_HOME = 0;
    private static final int MENU_CONTACTS = 1;
    private static final int MENU_RECENT = 2;
    private static final int MENU_SETTINGS = 3;
    private static final int MENU_DIALER = 4;
    private static final int MENU_CALL_INCOMING = 5;
    private static final int MENU_CALL_ACTIVE = 6;
    private int currentMenu = 0;
    private int homeSelectionX = 0;
    private int homeSelectionY = 0;
    private int listScrollOffset = 0;
    private int selectedIndex = 0;
    private int micGain = 100;
    private int speakerVolume = 100;
    private boolean micMuted = false;
    private String dialNumber = "";
    private int dialerSelectionX = 1;
    private int dialerSelectionY = 3;
    private float slideProgress = 0.0f;
    private long openTime;
    private List<Contact> contacts = new ArrayList<Contact>();
    private SignalState signalState = SignalState.STRONG;
    private long blackoutStartTime = 0L;
    private long connectingStartTime = 0L;
    private int signalLevel = 4;
    private float glitchIntensity = 0.0f;

    public PhoneScreen() {
        super((Component)Component.m_237113_((String)"Planar Phone"));
        this.contacts.add(new Contact("Steve", "555-0100"));
        this.contacts.add(new Contact("Alex", "555-0101"));
        this.contacts.add(new Contact("Herobrine", "666-6666"));
        this.contacts.add(new Contact("Notch", "111-1111"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.slideProgress = 0.0f;
        this.openTime = System.currentTimeMillis();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateSignalLogic();
        if (this.slideProgress < 1.0f) {
            this.slideProgress += 0.08f;
            if (this.slideProgress > 1.0f) {
                this.slideProgress = 1.0f;
            }
        }
        float maxScale = 1.0f;
        if (this.f_96544_ < 440) {
            maxScale = (float)(this.f_96544_ - 40) / 400.0f;
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.f_96543_, (float)this.f_96544_, 0.0f);
        guiGraphics.m_280168_().m_85841_(maxScale, maxScale, 1.0f);
        guiGraphics.m_280168_().m_252880_((float)(-this.f_96543_), (float)(-this.f_96544_), 0.0f);
        int x = this.f_96543_ - 220 - 20;
        int targetY = this.f_96544_ - 400 - 20;
        int startY = this.f_96544_;
        float easedProgress = (float)(1.0 - Math.pow(1.0f - this.slideProgress, 3.0));
        int y = (int)((float)startY + (float)(targetY - startY) * easedProgress);
        if (this.glitchIntensity > 0.0f && Math.random() < (double)this.glitchIntensity) {
            x = (int)((double)x + (Math.random() - 0.5) * 5.0 * (double)this.glitchIntensity);
            y = (int)((double)y + (Math.random() - 0.5) * 5.0 * (double)this.glitchIntensity);
        }
        this.renderPhoneBody(guiGraphics, x, y);
        if (this.signalState == SignalState.BLACKOUT) {
            guiGraphics.m_280509_(x + 2, y + 2, x + 220 - 2, y + 400 - 2, -16777216);
            guiGraphics.m_280137_(this.f_96547_, "NO SIGNAL", x + 110, y + 200, -5636096);
        } else if (this.signalState == SignalState.CONNECTING) {
            guiGraphics.m_280509_(x + 2, y + 2, x + 220 - 2, y + 400 - 2, -15724528);
            guiGraphics.m_280137_(this.f_96547_, "Baglaniliyor...", x + 110, y + 200, -171);
        } else {
            if (this.currentMenu == 0) {
                this.renderHomeScreen(guiGraphics, x, y);
            } else if (this.currentMenu == 1) {
                this.renderContactsScreen(guiGraphics, x, y);
            } else if (this.currentMenu == 4) {
                this.renderDialerScreen(guiGraphics, x, y);
            } else if (this.currentMenu == 3) {
                this.renderSettingsScreen(guiGraphics, x, y);
            } else if (this.currentMenu == 5) {
                this.renderIncomingCall(guiGraphics, x, y);
            } else if (this.currentMenu == 6) {
                this.renderActiveCall(guiGraphics, x, y);
            }
            if (this.glitchIntensity > 0.2f) {
                this.renderStaticNoise(guiGraphics, x, y);
            }
        }
        if (this.signalState != SignalState.BLACKOUT) {
            this.renderStatusBar(guiGraphics, x, y);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    private void updateSignalLogic() {
        boolean isOverworld;
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        boolean bl = isOverworld = Minecraft.m_91087_().f_91073_.m_46472_() == Level.f_46428_;
        if (isOverworld) {
            this.signalState = SignalState.STRONG;
            this.glitchIntensity = 0.0f;
            this.signalLevel = 4;
            return;
        }
        if (this.signalState == SignalState.STRONG) {
            this.signalState = SignalState.WEAK;
            this.signalLevel = 1;
        }
        this.glitchIntensity = 0.6f;
        long now = System.currentTimeMillis();
        if (this.signalState == SignalState.WEAK || this.signalState == SignalState.EMERGENCY) {
            if (Math.random() < 5.0E-4) {
                this.signalState = SignalState.BLACKOUT;
                this.blackoutStartTime = now;
                if (this.currentMenu == 6) {
                    this.currentMenu = 0;
                }
            }
        } else if (this.signalState == SignalState.BLACKOUT) {
            if (now - this.blackoutStartTime > 20000L) {
                this.signalState = SignalState.CONNECTING;
                this.connectingStartTime = now;
            }
        } else if (this.signalState == SignalState.CONNECTING && now - this.connectingStartTime > 3000L) {
            this.signalState = SignalState.EMERGENCY;
            this.signalLevel = 1;
        }
        if (this.signalState == SignalState.EMERGENCY) {
            this.signalLevel = (int)(Math.random() * 2.0);
            this.glitchIntensity = 0.8f;
        }
    }

    private void renderStatusBar(GuiGraphics guiGraphics, int x, int y) {
        boolean isOverworld = Minecraft.m_91087_().f_91073_.m_46472_() == Level.f_46428_;
        Object timeStr = isOverworld ? String.format("%02d:%02d", System.currentTimeMillis() / 60000L % 60L, System.currentTimeMillis() / 1000L % 60L) : "" + (int)(Math.random() * 9.0) + (int)(Math.random() * 9.0) + ":" + (int)(Math.random() * 9.0) + (int)(Math.random() * 9.0);
        guiGraphics.m_280137_(this.f_96547_, (String)timeStr, x + 110, y + 6, -3355444);
        int barColor = this.signalState == SignalState.STRONG ? 0xFFFFFF : (this.signalState == SignalState.EMERGENCY ? -43691 : -5592406);
        for (int i = 0; i < 4; ++i) {
            int h = 4 + i * 2;
            int bx = x + 220 - 25 + i * 4;
            int by = y + 6 + (10 - h);
            if (i < this.signalLevel) {
                guiGraphics.m_280509_(bx, by, bx + 2, by + h, barColor);
                continue;
            }
            guiGraphics.m_280509_(bx, by, bx + 2, by + h, 0x44444444);
        }
        String carrier = this.signalState == SignalState.EMERGENCY ? "ACIL DURUM" : (this.signalState == SignalState.WEAK ? "ROAMING" : "PlanarCell");
        guiGraphics.m_280056_(this.f_96547_, carrier, x + 5, y + 6, barColor, false);
    }

    private void renderStaticNoise(GuiGraphics guiGraphics, int x, int y) {
        for (int i = 0; i < 5; ++i) {
            int rx = x + (int)(Math.random() * 220.0);
            int ry = y + (int)(Math.random() * 400.0);
            int w = (int)(Math.random() * 50.0);
            int h = (int)(Math.random() * 2.0);
            guiGraphics.m_280509_(rx, ry, rx + w, ry + h, 0x55FFFFFF);
        }
    }

    private void renderPhoneBody(GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.enableBlend();
        guiGraphics.m_280024_(x, y, x + 220, y + 400, -585491942, -300937200);
        int borderColor = -12303292;
        guiGraphics.m_280637_(x - 2, y - 2, 224, 404, borderColor);
    }

    private void renderHomeScreen(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280137_(this.f_96547_, "Ana Men\u00fc", x + 110, y + 25, 0xFFFFFF);
        int iconSize = 45;
        int gap = 20;
        int startX = x + (220 - (iconSize * 2 + gap)) / 2;
        int startY = y + 80;
        this.drawHomeIcon(guiGraphics, startX, startY, 0, 0, "Rehber", -13710223);
        this.drawHomeIcon(guiGraphics, startX + iconSize + gap, startY, 1, 0, "Arama", -13330213);
        this.drawHomeIcon(guiGraphics, startX, startY + iconSize + gap + 10, 0, 1, "Gecmis", -932849);
        this.drawHomeIcon(guiGraphics, startX + iconSize + gap, startY + iconSize + gap + 10, 1, 1, "Ayarlar", -6969946);
    }

    private void drawHomeIcon(GuiGraphics guiGraphics, int x, int y, int col, int row, String label, int color) {
        boolean selected;
        boolean bl = selected = this.homeSelectionX == col && this.homeSelectionY == row;
        if (selected) {
            guiGraphics.m_280509_(x - 3, y - 3, x + 45 + 3, y + 45 + 3, -1);
        }
        guiGraphics.m_280509_(x, y, x + 45, y + 45, color);
        guiGraphics.m_280137_(this.f_96547_, label, x + 22, y + 50, selected ? -1 : -5592406);
    }

    private void renderContactsScreen(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280137_(this.f_96547_, "Rehber", x + 110, y + 20, 0xFFFFFF);
        int listY = y + 50;
        int itemHeight = 25;
        for (int i = 0; i < this.contacts.size(); ++i) {
            boolean selected;
            Contact c = this.contacts.get(i);
            int itemY = listY + i * itemHeight;
            boolean bl = selected = i == this.selectedIndex;
            if (selected) {
                guiGraphics.m_280509_(x + 5, itemY, x + 220 - 5, itemY + itemHeight, 0x44FFFFFF);
            }
            ResourceLocation skin = DefaultPlayerSkin.m_118626_();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)skin);
            guiGraphics.m_280411_(skin, x + 10, itemY + 4, 16, 16, 8.0f, 8.0f, 8, 8, 64, 64);
            guiGraphics.m_280488_(this.f_96547_, c.name, x + 35, itemY + 8, selected ? 0xFFFFFF : 0xCCCCCC);
        }
    }

    private void renderDialerScreen(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280137_(this.f_96547_, "Numara Cevir", x + 110, y + 20, 0xFFFFFF);
        guiGraphics.m_280509_(x + 20, y + 40, x + 220 - 20, y + 70, -13421773);
        guiGraphics.m_280488_(this.f_96547_, this.dialNumber, x + 30, y + 50, 0xFFFFFF);
        String[] keys = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "0", "#"};
        int startX = x + 35;
        int startY = y + 90;
        int keyGap = 15;
        int keySize = 35;
        for (int i = 0; i < 12; ++i) {
            boolean selected;
            int col = i % 3;
            int row = i / 3;
            int kx = startX + col * (keySize + keyGap);
            int ky = startY + row * (keySize + keyGap);
            boolean bl = selected = this.dialerSelectionX == col && this.dialerSelectionY == row;
            if (selected) {
                guiGraphics.m_280509_(kx - 2, ky - 2, kx + keySize + 2, ky + keySize + 2, -1);
            }
            guiGraphics.m_280509_(kx, ky, kx + keySize, ky + keySize, -12303292);
            guiGraphics.m_280137_(this.f_96547_, keys[i], kx + keySize / 2, ky + 12, 0xFFFFFF);
        }
        boolean callSelected = this.dialerSelectionY == 4;
        int callY = startY + 4 * (keySize + keyGap) - 10;
        if (callSelected) {
            guiGraphics.m_280509_(x + 48, callY - 2, x + 220 - 48, callY + 27, -1);
        }
        guiGraphics.m_280509_(x + 50, callY, x + 220 - 50, callY + 25, -13710223);
        guiGraphics.m_280137_(this.f_96547_, "ARA", x + 110, callY + 8, 0xFFFFFF);
    }

    private void renderSettingsScreen(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280137_(this.f_96547_, "Ayarlar", x + 110, y + 20, 0xFFFFFF);
        String[] labels = new String[]{"Mikrofon: " + (this.micMuted ? "KAPALI" : "ACIK"), "Mic Gain: " + this.micGain + "%", "Hoparl\u00f6r: " + this.speakerVolume + "%"};
        int startY = y + 60;
        for (int i = 0; i < labels.length; ++i) {
            int color;
            boolean selected = i == this.selectedIndex;
            int n = color = selected ? 0xFFFFFF : 0xAAAAAA;
            if (selected) {
                guiGraphics.m_280488_(this.f_96547_, ">", x + 10, startY + i * 30, 0xFFFFFF);
            }
            guiGraphics.m_280488_(this.f_96547_, labels[i], x + 25, startY + i * 30, color);
        }
        guiGraphics.m_280137_(this.f_96547_, "<Sol - Sag>", x + 110, y + 400 - 30, 0x666666);
    }

    private void renderActiveCall(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280509_(x, y, x + 220, y + 80, -14527198);
        guiGraphics.m_280137_(this.f_96547_, "Gorusme Suruyor...", x + 110, y + 30, 0xFFFFFF);
        guiGraphics.m_280137_(this.f_96547_, "Steve", x + 110, y + 50, 0xFFFFFF);
        int cy = y + 200;
        guiGraphics.m_280137_(this.f_96547_, "[H] Hoparlor", x + 110, cy, 0xFFFFFF);
        guiGraphics.m_280137_(this.f_96547_, "[M] Sustur", x + 110, cy + 20, 0xFFFFFF);
        guiGraphics.m_280137_(this.f_96547_, "[ENTER] Kapat", x + 110, cy + 60, -43691);
    }

    private void renderIncomingCall(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280509_(x, y, x + 220, y + 400, -587202526);
        guiGraphics.m_280137_(this.f_96547_, "Gelen Arama!", x + 110, y + 50, 0xFFFFFF);
        guiGraphics.m_280137_(this.f_96547_, "Bilinmeyen No", x + 110, y + 80, 0xAAAAAA);
        guiGraphics.m_280509_(x + 20, y + 250, x + 90, y + 290, -13710223);
        guiGraphics.m_280137_(this.f_96547_, "AC", x + 55, y + 265, 0xFFFFFF);
        guiGraphics.m_280509_(x + 110, y + 250, x + 180, y + 290, -1618884);
        guiGraphics.m_280137_(this.f_96547_, "REDDET", x + 145, y + 265, 0xFFFFFF);
        guiGraphics.m_280137_(this.f_96547_, "Sol / Sag", x + 110, y + 310, 0xAAAAAA);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 301) {
            this.currentMenu = 5;
            return true;
        }
        if (this.currentMenu == 0) {
            this.handleHomeInput(keyCode);
        } else if (this.currentMenu == 1) {
            if (keyCode == 265) {
                if (this.selectedIndex > 0) {
                    --this.selectedIndex;
                }
            } else if (keyCode == 264) {
                if (this.selectedIndex < this.contacts.size() - 1) {
                    ++this.selectedIndex;
                }
            } else if (keyCode == 257) {
                this.dialNumber = this.contacts.get((int)this.selectedIndex).number;
                this.currentMenu = 6;
            }
        } else if (this.currentMenu == 4) {
            this.handleDialerInput(keyCode);
        } else if (this.currentMenu == 3) {
            this.handleSettingsInput(keyCode);
        } else if (this.currentMenu == 5) {
            if (keyCode == 263) {
                this.currentMenu = 6;
            }
            if (keyCode == 262) {
                this.currentMenu = 0;
            }
        } else if (this.currentMenu == 6 && keyCode == 257) {
            this.currentMenu = 0;
        }
        if (keyCode == 256 || keyCode == 259) {
            if (this.dialNumber.length() > 0 && this.currentMenu == 4) {
                this.dialNumber = this.dialNumber.substring(0, this.dialNumber.length() - 1);
                return true;
            }
            if (this.currentMenu != 0) {
                this.currentMenu = 0;
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void handleHomeInput(int key) {
        if (key == 263) {
            this.homeSelectionX = Math.max(0, this.homeSelectionX - 1);
        }
        if (key == 262) {
            this.homeSelectionX = Math.min(1, this.homeSelectionX + 1);
        }
        if (key == 265) {
            this.homeSelectionY = Math.max(0, this.homeSelectionY - 1);
        }
        if (key == 264) {
            this.homeSelectionY = Math.min(1, this.homeSelectionY + 1);
        }
        if (key == 257) {
            if (this.homeSelectionY == 0 && this.homeSelectionX == 0) {
                this.currentMenu = 1;
            }
            if (this.homeSelectionY == 0 && this.homeSelectionX == 1) {
                this.currentMenu = 4;
            }
            if (this.homeSelectionY == 1 && this.homeSelectionX == 0) {
                this.currentMenu = 2;
            }
            if (this.homeSelectionY == 1 && this.homeSelectionX == 1) {
                this.currentMenu = 3;
                this.selectedIndex = 0;
            }
        }
    }

    private void handleDialerInput(int key) {
        if (key == 263) {
            this.dialerSelectionX = Math.max(0, this.dialerSelectionX - 1);
        }
        if (key == 262) {
            this.dialerSelectionX = Math.min(2, this.dialerSelectionX + 1);
        }
        if (key == 265) {
            this.dialerSelectionY = Math.max(0, this.dialerSelectionY - 1);
        }
        if (key == 264) {
            this.dialerSelectionY = Math.min(4, this.dialerSelectionY + 1);
        }
        if (key == 257) {
            if (this.dialerSelectionY == 4) {
                if (!this.dialNumber.isEmpty()) {
                    this.currentMenu = 6;
                }
                return;
            }
            int index = this.dialerSelectionY * 3 + this.dialerSelectionX;
            String chars = "123456789*0#";
            if (index < chars.length()) {
                this.dialNumber = this.dialNumber + chars.charAt(index);
            }
        }
    }

    private void handleSettingsInput(int key) {
        if (key == 265) {
            this.selectedIndex = Math.max(0, this.selectedIndex - 1);
        }
        if (key == 264) {
            this.selectedIndex = Math.min(2, this.selectedIndex + 1);
        }
        int step = 5;
        if (key == 263) {
            if (this.selectedIndex == 0) {
                boolean bl = this.micMuted = !this.micMuted;
            }
            if (this.selectedIndex == 1) {
                this.micGain = Math.max(0, this.micGain - step);
            }
            if (this.selectedIndex == 2) {
                this.speakerVolume = Math.max(0, this.speakerVolume - step);
            }
        }
        if (key == 262) {
            if (this.selectedIndex == 0) {
                boolean bl = this.micMuted = !this.micMuted;
            }
            if (this.selectedIndex == 1) {
                this.micGain = Math.min(200, this.micGain + step);
            }
            if (this.selectedIndex == 2) {
                this.speakerVolume = Math.min(100, this.speakerVolume + step);
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private static enum SignalState {
        STRONG,
        WEAK,
        BLACKOUT,
        CONNECTING,
        EMERGENCY;

    }

    private static class Contact {
        String name;
        String number;

        public Contact(String name, String number) {
            this.name = name;
            this.number = number;
        }
    }
}

