/*
 * Decompiled with CFR 0.152.
 */
package com.retro.planar.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import org.joml.Matrix4f;
import org.slf4j.Logger;

public class PhoneBrowserScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String DEFAULT_URL = "https://www.google.com";
    private static final int BROWSER_WIDTH = 800;
    private static final int BROWSER_HEIGHT = 600;
    private Object browser;
    private Object renderer;
    private String currentUrl;
    private boolean browserReady = false;
    private String urlInput = "";
    private boolean urlBarFocused = false;
    private String errorMessage = null;
    private List<String> debugInfo = new ArrayList<String>();
    private int browserX;
    private int browserY;
    private Method resizeMethod;
    private Method loadURLMethod;
    private Method closeMethod;
    private Method getRendererMethod;
    private Method sendMousePressMethod;
    private Method sendMouseReleaseMethod;
    private Method sendMouseMoveMethod;
    private Method sendMouseWheelMethod;
    private Method sendKeyPressMethod;
    private Method sendKeyReleaseMethod;
    private Method sendKeyTypedMethod;
    private Method getTextureIDMethod;
    private Method isTransparentMethod;

    public PhoneBrowserScreen() {
        super((Component)Component.m_237113_((String)"Telefon Tarayici"));
        this.currentUrl = DEFAULT_URL;
    }

    public PhoneBrowserScreen(String url) {
        super((Component)Component.m_237113_((String)"Telefon Tarayici"));
        this.currentUrl = url != null && !url.isEmpty() ? url : DEFAULT_URL;
    }

    protected void m_7856_() {
        block27: {
            super.m_7856_();
            this.debugInfo.clear();
            Minecraft mc = Minecraft.m_91087_();
            double guiScale = mc.m_91268_().m_85449_();
            double effectiveScale = Math.min(guiScale, 3.0);
            int actualBrowserWidth = (int)(800.0 * effectiveScale);
            int actualBrowserHeight = (int)(600.0 * effectiveScale);
            this.browserX = (this.f_96543_ - 800) / 2;
            this.browserY = (this.f_96544_ - 600) / 2 + 20;
            try {
                Class<?> mcefClass = Class.forName("com.cinemamod.mcef.MCEF");
                this.debugInfo.add("MCEF found, scale=" + guiScale);
                Method isInitializedMethod = mcefClass.getMethod("isInitialized", new Class[0]);
                boolean isInitialized = (Boolean)isInitializedMethod.invoke(null, new Object[0]);
                this.debugInfo.add("Initialized: " + isInitialized);
                if (!isInitialized) {
                    this.errorMessage = "MCEF yukleniyor, lutfen bekleyin...";
                    return;
                }
                this.browser = null;
                try {
                    Method createBrowserMethod = mcefClass.getMethod("createBrowser", String.class, Boolean.TYPE, Integer.TYPE, Integer.TYPE);
                    this.browser = createBrowserMethod.invoke(null, this.currentUrl, true, actualBrowserWidth, actualBrowserHeight);
                    this.debugInfo.add("Browser: " + actualBrowserWidth + "x" + actualBrowserHeight);
                }
                catch (NoSuchMethodException e) {
                    try {
                        Method createBrowserMethod = mcefClass.getMethod("createBrowser", String.class);
                        this.browser = createBrowserMethod.invoke(null, this.currentUrl);
                    }
                    catch (NoSuchMethodException e2) {
                        this.debugInfo.add("createBrowser not found");
                    }
                }
                if (this.browser != null) {
                    Class<?> browserClass = this.browser.getClass();
                    try {
                        this.resizeMethod = browserClass.getMethod("resize", Integer.TYPE, Integer.TYPE);
                    }
                    catch (NoSuchMethodException e2) {
                        // empty catch block
                    }
                    try {
                        this.loadURLMethod = browserClass.getMethod("loadURL", String.class);
                    }
                    catch (NoSuchMethodException e2) {
                        // empty catch block
                    }
                    try {
                        this.closeMethod = browserClass.getMethod("close", new Class[0]);
                    }
                    catch (NoSuchMethodException e2) {
                        // empty catch block
                    }
                    try {
                        this.getRendererMethod = browserClass.getMethod("getRenderer", new Class[0]);
                    }
                    catch (NoSuchMethodException e2) {
                        // empty catch block
                    }
                    try {
                        this.sendMousePressMethod = browserClass.getMethod("sendMousePress", Integer.TYPE, Integer.TYPE, Integer.TYPE);
                        this.sendMouseReleaseMethod = browserClass.getMethod("sendMouseRelease", Integer.TYPE, Integer.TYPE, Integer.TYPE);
                        this.sendMouseMoveMethod = browserClass.getMethod("sendMouseMove", Integer.TYPE, Integer.TYPE);
                        this.sendMouseWheelMethod = browserClass.getMethod("sendMouseWheel", Integer.TYPE, Integer.TYPE, Double.TYPE, Integer.TYPE);
                        this.sendKeyPressMethod = browserClass.getMethod("sendKeyPress", Integer.TYPE, Integer.TYPE, Integer.TYPE);
                        this.sendKeyReleaseMethod = browserClass.getMethod("sendKeyRelease", Integer.TYPE, Integer.TYPE, Integer.TYPE);
                        this.sendKeyTypedMethod = browserClass.getMethod("sendKeyTyped", Character.TYPE, Integer.TYPE);
                    }
                    catch (NoSuchMethodException e2) {
                        // empty catch block
                    }
                    if (this.getRendererMethod != null) {
                        this.renderer = this.getRendererMethod.invoke(this.browser, new Object[0]);
                        if (this.renderer != null) {
                            Class<?> rendererClass = this.renderer.getClass();
                            this.debugInfo.add("Renderer: " + rendererClass.getSimpleName());
                            try {
                                this.getTextureIDMethod = rendererClass.getMethod("getTextureID", new Class[0]);
                                this.debugInfo.add("getTextureID found");
                            }
                            catch (NoSuchMethodException e) {
                                this.debugInfo.add("getTextureID NOT found");
                            }
                            try {
                                this.isTransparentMethod = rendererClass.getMethod("isTransparent", new Class[0]);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                            if (this.getTextureIDMethod != null) {
                                this.browserReady = true;
                                this.urlInput = this.currentUrl;
                                this.debugInfo.add("Browser ready!");
                                LOGGER.info("[Planarcell] Browser ready with texture rendering");
                            } else {
                                this.errorMessage = "getTextureID metodu bulunamadi";
                            }
                            break block27;
                        }
                        this.errorMessage = "Renderer null";
                        break block27;
                    }
                    this.errorMessage = "getRenderer metodu yok";
                    break block27;
                }
                this.errorMessage = "Tarayici olusturulamadi";
            }
            catch (ClassNotFoundException e) {
                this.errorMessage = "MCEF modu yuklenmemis!";
            }
            catch (Exception e) {
                this.errorMessage = "Hata: " + e.getMessage();
                LOGGER.error("[Planarcell] Browser init error", (Throwable)e);
            }
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int frameHeight;
        int frameWidth;
        int frameY;
        int frameX;
        Minecraft mc;
        block8: {
            this.m_280273_(guiGraphics);
            mc = Minecraft.m_91087_();
            frameX = this.browserX - 20;
            frameY = this.browserY - 60;
            frameWidth = 840;
            frameHeight = 700;
            guiGraphics.m_280509_(frameX, frameY, frameX + frameWidth, frameY + frameHeight, -15066578);
            guiGraphics.m_280509_(frameX + 2, frameY + 2, frameX + frameWidth - 2, frameY + frameHeight - 2, -15326914);
            guiGraphics.m_280509_(frameX + 5, frameY + 5, frameX + frameWidth - 5, frameY + 35, -15780768);
            guiGraphics.m_280137_(mc.f_91062_, "PLANARCELL BROWSER", frameX + frameWidth / 2, frameY + 15, -16711681);
            int urlBarY = this.browserY - 25;
            guiGraphics.m_280509_(this.browserX, urlBarY, this.browserX + 800, urlBarY + 20, this.urlBarFocused ? -1 : -13421773);
            guiGraphics.m_280056_(mc.f_91062_, (String)(this.urlInput.length() > 80 ? this.urlInput.substring(0, 80) + "..." : this.urlInput), this.browserX + 5, urlBarY + 6, this.urlBarFocused ? -16777216 : -1, false);
            if (this.browserReady && this.browser != null && this.renderer != null && this.getTextureIDMethod != null) {
                try {
                    int textureId;
                    double guiScale = mc.m_91268_().m_85449_();
                    double effectiveScale = Math.min(guiScale, 3.0);
                    int actualBrowserWidth = (int)(800.0 * effectiveScale);
                    int actualBrowserHeight = (int)(600.0 * effectiveScale);
                    if (this.resizeMethod != null) {
                        this.resizeMethod.invoke(this.browser, actualBrowserWidth, actualBrowserHeight);
                    }
                    if ((textureId = ((Integer)this.getTextureIDMethod.invoke(this.renderer, new Object[0])).intValue()) > 0) {
                        this.drawBrowserTexture(guiGraphics, textureId, this.browserX, this.browserY, 800, 600);
                        break block8;
                    }
                    guiGraphics.m_280509_(this.browserX, this.browserY, this.browserX + 800, this.browserY + 600, -14540254);
                    guiGraphics.m_280137_(mc.f_91062_, "Sayfa yukleniyor...", this.browserX + 400, this.browserY + 300, -1);
                }
                catch (Exception e) {
                    guiGraphics.m_280509_(this.browserX, this.browserY, this.browserX + 800, this.browserY + 600, -14540254);
                    guiGraphics.m_280137_(mc.f_91062_, "Render hatasi: " + e.getMessage(), this.browserX + 400, this.browserY + 300, -65536);
                    LOGGER.error("[Planarcell] Render error", (Throwable)e);
                }
            } else {
                guiGraphics.m_280509_(this.browserX, this.browserY, this.browserX + 800, this.browserY + 600, -14540254);
                String msg = this.errorMessage != null ? this.errorMessage : "Yukleniyor...";
                String[] lines = msg.split("\n");
                int lineY = this.browserY + 50;
                for (String line : lines) {
                    guiGraphics.m_280137_(mc.f_91062_, line, this.browserX + 400, lineY, -1);
                    lineY += 12;
                }
                guiGraphics.m_280056_(mc.f_91062_, "Debug:", this.browserX + 10, lineY += 20, -7829368, false);
                lineY += 12;
                for (String info : this.debugInfo) {
                    guiGraphics.m_280056_(mc.f_91062_, "- " + info, this.browserX + 10, lineY, -10066330, false);
                    if ((lineY += 10) <= this.browserY + 600 - 20) continue;
                    break;
                }
            }
        }
        guiGraphics.m_280137_(mc.f_91062_, "ESC: Kapat | F5: Yenile | ENTER: Git", frameX + frameWidth / 2, frameY + frameHeight - 15, -7829368);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void drawBrowserTexture(GuiGraphics guiGraphics, int textureId, int x, int y, int width, int height) {
        RenderSystem.setShaderTexture((int)0, (int)textureId);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix, (float)x, (float)y, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)x, (float)(y + height), 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)(x + width), (float)(y + height), 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)(x + width), (float)y, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int urlBarY = this.browserY - 25;
        if (mouseX >= (double)this.browserX && mouseX <= (double)(this.browserX + 800) && mouseY >= (double)urlBarY && mouseY <= (double)(urlBarY + 20)) {
            this.urlBarFocused = true;
            return true;
        }
        this.urlBarFocused = false;
        if (this.browserReady && this.browser != null && this.sendMousePressMethod != null) {
            int relX = (int)mouseX - this.browserX;
            int relY = (int)mouseY - this.browserY;
            if (relX >= 0 && relX < 800 && relY >= 0 && relY < 600) {
                try {
                    this.sendMousePressMethod.invoke(this.browser, relX, relY, button);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.browserReady && this.browser != null && this.sendMouseReleaseMethod != null) {
            try {
                this.sendMouseReleaseMethod.invoke(this.browser, (int)mouseX - this.browserX, (int)mouseY - this.browserY, button);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.browserReady && this.browser != null && this.sendMouseMoveMethod != null) {
            try {
                this.sendMouseMoveMethod.invoke(this.browser, (int)mouseX - this.browserX, (int)mouseY - this.browserY);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public void m_94757_(double mouseX, double mouseY) {
        if (this.browserReady && this.browser != null && this.sendMouseMoveMethod != null) {
            int relX = (int)mouseX - this.browserX;
            int relY = (int)mouseY - this.browserY;
            if (relX >= 0 && relX < 800 && relY >= 0 && relY < 600) {
                try {
                    this.sendMouseMoveMethod.invoke(this.browser, relX, relY);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        super.m_94757_(mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.browserReady && this.browser != null && this.sendMouseWheelMethod != null) {
            int relX = (int)mouseX - this.browserX;
            int relY = (int)mouseY - this.browserY;
            if (relX >= 0 && relX < 800 && relY >= 0 && relY < 600) {
                try {
                    this.sendMouseWheelMethod.invoke(this.browser, relX, relY, delta, 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        if (keyCode == 294 && this.browserReady && this.browser != null && this.loadURLMethod != null) {
            try {
                this.loadURLMethod.invoke(this.browser, this.currentUrl);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        if (this.urlBarFocused) {
            if (keyCode == 257) {
                this.navigateTo(this.urlInput);
                this.urlBarFocused = false;
                return true;
            }
            if (keyCode == 259 && this.urlInput.length() > 0) {
                this.urlInput = this.urlInput.substring(0, this.urlInput.length() - 1);
                return true;
            }
        }
        if (this.browserReady && this.browser != null && !this.urlBarFocused && this.sendKeyPressMethod != null) {
            try {
                this.sendKeyPressMethod.invoke(this.browser, keyCode, scanCode, modifiers);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.browserReady && this.browser != null && !this.urlBarFocused && this.sendKeyReleaseMethod != null) {
            try {
                this.sendKeyReleaseMethod.invoke(this.browser, keyCode, scanCode, modifiers);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.urlBarFocused) {
            this.urlInput = this.urlInput + codePoint;
            return true;
        }
        if (this.browserReady && this.browser != null && this.sendKeyTypedMethod != null) {
            try {
                this.sendKeyTypedMethod.invoke(this.browser, Character.valueOf(codePoint), modifiers);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.m_5534_(codePoint, modifiers);
    }

    private void navigateTo(String url) {
        if (url == null || ((String)url).isEmpty()) {
            return;
        }
        if (!((String)url).startsWith("http://") && !((String)url).startsWith("https://")) {
            url = !((String)url).contains(".") || ((String)url).contains(" ") ? "https://www.google.com/search?q=" + ((String)url).replace(" ", "+") : "https://" + (String)url;
        }
        this.currentUrl = url;
        this.urlInput = url;
        if (this.browserReady && this.browser != null && this.loadURLMethod != null) {
            try {
                this.loadURLMethod.invoke(this.browser, url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void m_7379_() {
        if (this.browser != null && this.closeMethod != null) {
            try {
                this.closeMethod.invoke(this.browser, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.browser = null;
        }
        this.renderer = null;
        this.browserReady = false;
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }

    public static boolean isBrowserAvailable() {
        try {
            Class<?> mcefClass = Class.forName("com.cinemamod.mcef.MCEF");
            Method isInitializedMethod = mcefClass.getMethod("isInitialized", new Class[0]);
            return (Boolean)isInitializedMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return false;
        }
    }
}

