/*
 * Decompiled with CFR 0.152.
 */
package com.retro.planar.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.retro.planar.ModSounds;
import com.retro.planar.client.gui.PhoneBrowserScreen;
import com.retro.planar.network.CallHoldPacket;
import com.retro.planar.network.CallRequestPacket;
import com.retro.planar.network.CallResponsePacket;
import com.retro.planar.network.CallStatusPacket;
import com.retro.planar.network.EndCallPacket;
import com.retro.planar.network.NetworkHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class HUDPhoneRenderer {
    private static final int BASE_PHONE_WIDTH = 220;
    private static final int BASE_PHONE_HEIGHT = 400;
    private static final float[] SCALE_OPTIONS = new float[]{0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 1.0f};
    private static final String[] SCALE_LABELS = new String[]{"50%", "60%", "70%", "80%", "90%", "100%"};
    private int currentScaleIndex = 2;
    private static HUDPhoneRenderer INSTANCE;
    public boolean isOpen = false;
    private static final int MENU_HOME = 0;
    private static final int MENU_CONTACTS = 1;
    private static final int MENU_DIALER = 2;
    private static final int MENU_SETTINGS = 3;
    private static final int MENU_INCOMING_CALL = 4;
    private static final int MENU_OUTGOING_CALL = 5;
    private static final int MENU_ACTIVE_CALL = 6;
    private static final int MENU_EMERGENCY = 7;
    private static final int MENU_WAITING_CALL = 8;
    private static final int MENU_INFO = 9;
    private static final int MENU_TEST_SELECTION = 10;
    private int currentMenu = 0;
    private int selectedIndex = 0;
    private String dialedNumber = "";
    private String myNumber = "Bilinmiyor";
    private boolean isInTestMode = false;
    private int testScenario = 0;
    private int volumeLevel = 100;
    private boolean vibrationEnabled = true;
    private boolean notificationsEnabled = true;
    private int selectedRingtone = 0;
    private int signalStrength = 100;
    private boolean hasSignal = true;
    private boolean emergencyMode = false;
    private float directionToNearest = 0.0f;
    private double distanceToNearest = 0.0;
    private String currentDimension = "overworld";
    private boolean stationBroken = false;
    private long lastGlitchTime = 0L;
    private boolean isGlitching = false;
    private Random glitchRandom = new Random();
    private float glitchDirection = 0.0f;
    private double glitchDistance = 0.0;
    private UUID currentCallPartner = null;
    private String currentCallPartnerName = "";
    private long callStartTime = 0L;
    private boolean callOnHold = false;
    private UUID heldCallPartner = null;
    private String heldCallPartnerName = "";
    private UUID incomingCallerUUID = null;
    private String incomingCallerName = "";
    private List<WaitingCallInfo> waitingCalls = new ArrayList<WaitingCallInfo>();
    private List<Contact> contacts = new ArrayList<Contact>();
    private boolean voiceChatAvailable = false;
    private long animationStartTime = 0L;

    public static HUDPhoneRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HUDPhoneRenderer();
        }
        return INSTANCE;
    }

    public void toggle() {
        boolean bl = this.isOpen = !this.isOpen;
        if (this.isOpen) {
            this.playClick();
            this.updateContacts();
            this.checkVoiceChat();
            this.animationStartTime = System.currentTimeMillis();
        }
    }

    private float getScale() {
        return SCALE_OPTIONS[this.currentScaleIndex];
    }

    public String getCurrentScaleLabel() {
        return SCALE_LABELS[this.currentScaleIndex];
    }

    public void increaseScale() {
        if (this.currentScaleIndex < SCALE_OPTIONS.length - 1) {
            ++this.currentScaleIndex;
            this.playClick();
        }
    }

    public void decreaseScale() {
        if (this.currentScaleIndex > 0) {
            --this.currentScaleIndex;
            this.playClick();
        }
    }

    public void handleBackKey() {
        switch (this.currentMenu) {
            case 0: {
                this.isOpen = false;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                this.currentMenu = 0;
                this.selectedIndex = 0;
                break;
            }
            case 5: {
                this.endCurrentCall();
                this.currentMenu = 0;
                this.selectedIndex = 0;
                break;
            }
            case 8: {
                this.currentMenu = this.currentCallPartner != null ? 6 : 0;
                this.selectedIndex = 0;
                break;
            }
            default: {
                this.currentMenu = 0;
                this.selectedIndex = 0;
            }
        }
        this.playClick();
    }

    public void updateSignalInfo(int strength, boolean hasSignal, boolean emergency, float direction, double distance, String dimension, boolean broken) {
        this.signalStrength = strength;
        this.hasSignal = hasSignal;
        this.emergencyMode = emergency;
        this.directionToNearest = direction;
        this.distanceToNearest = distance;
        this.currentDimension = dimension;
        this.stationBroken = broken;
        if (emergency && this.currentMenu != 6 && this.currentMenu != 4 && this.currentMenu != 5 && this.isOpen) {
            this.currentMenu = 7;
        }
        if (hasSignal && this.currentMenu == 7) {
            this.currentMenu = 0;
        }
    }

    public void updateContacts() {
        this.contacts.clear();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() != null && mc.f_91074_ != null) {
            for (PlayerInfo info : mc.m_91403_().m_105142_()) {
                if (info.m_105312_().getId().equals(mc.f_91074_.m_20148_())) continue;
                this.contacts.add(new Contact(info.m_105312_().getName(), this.generatePhoneNumber(info.m_105312_().getId()), info.m_105312_().getId()));
            }
        }
    }

    public void checkVoiceChat() {
        try {
            Class.forName("de.maxhenkel.voicechat.api.VoicechatApi");
            this.voiceChatAvailable = true;
        }
        catch (ClassNotFoundException e) {
            this.voiceChatAvailable = false;
        }
    }

    public String generatePhoneNumber(UUID uuid) {
        long hash = uuid.getMostSignificantBits();
        return String.format("%03d-%03d-%04d", Math.abs((int)(hash % 1000L)), Math.abs((int)((hash >> 10) % 1000L)), Math.abs((int)((hash >> 20) % 10000L)));
    }

    public void showIncomingCall(UUID callerUUID, String callerName) {
        if (this.currentMenu == 6) {
            this.waitingCalls.add(new WaitingCallInfo(callerUUID, callerName));
            this.currentMenu = 8;
            this.playRingtone();
            return;
        }
        this.incomingCallerUUID = callerUUID;
        this.incomingCallerName = callerName;
        this.currentMenu = 4;
        this.isOpen = true;
        this.playRingtone();
    }

    public void showWaitingCall(UUID callerUUID, String callerName) {
        this.waitingCalls.add(new WaitingCallInfo(callerUUID, callerName));
        if (this.currentMenu == 6) {
            this.currentMenu = 8;
            this.playRingtone();
        }
    }

    public void clearWaitingCall(UUID callerUUID) {
        this.waitingCalls.removeIf(w -> w.callerUUID.equals(callerUUID));
        if (this.waitingCalls.isEmpty() && this.currentMenu == 8) {
            this.currentMenu = this.currentCallPartner != null ? 6 : 0;
        }
    }

    public void updateCallStatus(CallStatusPacket.Status status, String otherPlayerName) {
        switch (status) {
            case RINGING: {
                this.currentMenu = 5;
                this.currentCallPartnerName = otherPlayerName;
                this.playDialSound();
                break;
            }
            case CONNECTED: {
                this.currentMenu = 6;
                this.currentCallPartnerName = otherPlayerName;
                this.callStartTime = System.currentTimeMillis();
                this.playConnectSound();
                break;
            }
            case BUSY: {
                this.currentMenu = 0;
                this.currentCallPartner = null;
                this.currentCallPartnerName = "";
                this.playBusySound();
                break;
            }
            case REJECTED: {
                this.currentMenu = 0;
                this.currentCallPartner = null;
                this.currentCallPartnerName = "";
                this.playBusySound();
                break;
            }
            case ENDED: {
                this.handleCallEnded();
            }
        }
    }

    private void handleCallEnded() {
        this.playEndSound();
        if (this.heldCallPartner != null) {
            this.currentCallPartner = this.heldCallPartner;
            this.currentCallPartnerName = this.heldCallPartnerName;
            this.heldCallPartner = null;
            this.heldCallPartnerName = "";
            this.callOnHold = false;
            this.currentMenu = 6;
            NetworkHandler.sendToServer(new CallHoldPacket(CallHoldPacket.Action.RESUME_HELD));
        } else {
            this.currentMenu = 0;
            this.currentCallPartner = null;
            this.currentCallPartnerName = "";
        }
    }

    public void initiateCall(UUID targetUUID, String targetName) {
        if (!this.hasSignal) {
            return;
        }
        this.currentCallPartner = targetUUID;
        this.currentCallPartnerName = targetName;
        this.currentMenu = 5;
        NetworkHandler.sendToServer(new CallRequestPacket(targetUUID));
    }

    private void dialByNumber(String number) {
        String cleanNumber = number.replace("-", "").replace(" ", "");
        Contact foundContact = null;
        for (Contact c : this.contacts) {
            String contactNumber = c.number.replace("-", "").replace(" ", "");
            if (!contactNumber.equals(cleanNumber)) continue;
            foundContact = c;
            break;
        }
        if (foundContact != null) {
            this.playClick();
            this.dialedNumber = "";
            this.initiateCall(foundContact.uuid, foundContact.name);
        } else {
            this.playBusySound();
            this.currentCallPartnerName = "Numara gecersiz: " + number;
            this.currentMenu = 5;
            this.dialedNumber = "";
        }
    }

    public void acceptIncomingCall() {
        if (this.incomingCallerUUID != null) {
            this.currentCallPartner = this.incomingCallerUUID;
            this.currentCallPartnerName = this.incomingCallerName;
            this.callStartTime = System.currentTimeMillis();
            this.currentMenu = 6;
            NetworkHandler.sendToServer(new CallResponsePacket(this.incomingCallerUUID, true));
            this.playConnectSound();
            this.incomingCallerUUID = null;
            this.incomingCallerName = "";
        }
    }

    public void rejectIncomingCall() {
        if (this.incomingCallerUUID != null) {
            NetworkHandler.sendToServer(new CallResponsePacket(this.incomingCallerUUID, false));
            this.playEndSound();
            this.incomingCallerUUID = null;
            this.incomingCallerName = "";
            this.currentMenu = this.currentCallPartner != null ? 6 : 0;
        }
    }

    public void acceptWaitingCall(WaitingCallInfo waitingCall) {
        if (this.currentCallPartner != null) {
            this.heldCallPartner = this.currentCallPartner;
            this.heldCallPartnerName = this.currentCallPartnerName;
            this.callOnHold = true;
        }
        this.currentCallPartner = waitingCall.callerUUID;
        this.currentCallPartnerName = waitingCall.callerName;
        this.callStartTime = System.currentTimeMillis();
        this.waitingCalls.remove(waitingCall);
        NetworkHandler.sendToServer(new CallHoldPacket(CallHoldPacket.Action.SWITCH_TO_WAITING, waitingCall.callerUUID));
        this.playConnectSound();
        this.currentMenu = 6;
    }

    public void rejectWaitingCall(WaitingCallInfo waitingCall) {
        this.waitingCalls.remove(waitingCall);
        NetworkHandler.sendToServer(new CallResponsePacket(waitingCall.callerUUID, false));
        if (this.waitingCalls.isEmpty()) {
            this.currentMenu = 6;
        }
    }

    public void endCurrentCall() {
        if (this.isInTestMode) {
            this.isInTestMode = false;
            this.currentMenu = 10;
            this.handleCallEnded();
            return;
        }
        NetworkHandler.sendToServer(new EndCallPacket());
        this.handleCallEnded();
    }

    public void holdCurrentCall() {
        if (this.currentCallPartner != null && !this.callOnHold) {
            this.heldCallPartner = this.currentCallPartner;
            this.heldCallPartnerName = this.currentCallPartnerName;
            this.callOnHold = true;
            this.currentCallPartner = null;
            this.currentCallPartnerName = "";
            NetworkHandler.sendToServer(new CallHoldPacket(CallHoldPacket.Action.HOLD_CURRENT));
            this.currentMenu = 0;
        }
    }

    public void resumeHeldCall() {
        if (this.heldCallPartner != null) {
            this.currentCallPartner = this.heldCallPartner;
            this.currentCallPartnerName = this.heldCallPartnerName;
            this.heldCallPartner = null;
            this.heldCallPartnerName = "";
            this.callOnHold = false;
            NetworkHandler.sendToServer(new CallHoldPacket(CallHoldPacket.Action.RESUME_HELD));
            this.currentMenu = 6;
        }
    }

    public void render(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        if (!this.isOpen) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (this.myNumber.equals("Bilinmiyor")) {
            long uuidMost = mc.f_91074_.m_20148_().getMostSignificantBits();
            long uuidLeast = mc.f_91074_.m_20148_().getLeastSignificantBits();
            long code = Math.abs(uuidMost ^ uuidLeast) % 10000000000L;
            String numStr = String.format("%010d", code);
            this.myNumber = numStr.substring(0, 3) + "-" + numStr.substring(3, 6) + "-" + numStr.substring(6);
        }
        float animProgress = Math.min(1.0f, (float)(System.currentTimeMillis() - this.animationStartTime) / 200.0f);
        float scale = this.getScale();
        int scaledWidth = (int)(220.0f * scale);
        int scaledHeight = (int)(400.0f * scale);
        int phoneScreenX = screenWidth - scaledWidth - 20;
        int phoneScreenY = (int)((float)(screenHeight / 2 - scaledHeight / 2) + (1.0f - animProgress) * 50.0f * scale);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)phoneScreenX, (float)phoneScreenY, 0.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280509_(4, 4, 224, 404, 0x40000000);
        this.renderPhoneBodyScaled(guiGraphics);
        this.renderStatusBarScaled(guiGraphics);
        int contentY = 30;
        if (this.isNether() && this.emergencyMode) {
            this.updateGlitchEffect();
        }
        switch (this.currentMenu) {
            case 0: {
                this.renderHomeScreenScaled(guiGraphics, contentY);
                break;
            }
            case 1: {
                this.renderContactsScreenScaled(guiGraphics, contentY);
                break;
            }
            case 2: {
                this.renderDialerScreenScaled(guiGraphics, contentY);
                break;
            }
            case 3: {
                this.renderSettingsScreenScaled(guiGraphics, contentY);
                break;
            }
            case 4: {
                this.renderIncomingCallScreenScaled(guiGraphics, contentY);
                break;
            }
            case 5: {
                this.renderOutgoingCallScreenScaled(guiGraphics, contentY);
                break;
            }
            case 6: {
                this.renderActiveCallScreenScaled(guiGraphics, contentY);
                break;
            }
            case 7: {
                this.renderEmergencyScreenScaled(guiGraphics, contentY);
                break;
            }
            case 8: {
                this.renderWaitingCallScreenScaled(guiGraphics, contentY);
                break;
            }
            case 9: {
                this.renderInfoScreenScaled(guiGraphics, contentY);
                break;
            }
            case 10: {
                this.renderTestSelectionScreenScaled(guiGraphics, contentY);
            }
        }
        if (this.heldCallPartner != null && this.currentMenu != 6) {
            this.renderHeldCallIndicatorScaled(guiGraphics, 360);
        }
        if (!this.hasSignal && this.currentMenu != 7) {
            this.renderStaticNoiseScaled(guiGraphics);
        }
        guiGraphics.m_280168_().m_85849_();
        RenderSystem.disableBlend();
    }

    private void renderPhoneBodyScaled(GuiGraphics guiGraphics) {
        guiGraphics.m_280509_(0, 0, 220, 400, -15066578);
        guiGraphics.m_280509_(2, 2, 218, 398, -15326914);
        guiGraphics.m_280509_(8, 25, 212, 385, -15790301);
    }

    private void renderStatusBarScaled(GuiGraphics guiGraphics) {
        long blink;
        Minecraft mc = Minecraft.m_91087_();
        guiGraphics.m_280509_(8, 5, 212, 22, -15066578);
        int barX = 15;
        int barY = 10;
        int signalBars = this.signalStrength / 20;
        for (int i = 0; i < 5; ++i) {
            int barHeight = 3 + i * 2;
            int color = i < signalBars ? this.getSignalColor() : -13421773;
            guiGraphics.m_280509_(barX + i * 4, barY + (10 - barHeight), barX + i * 4 + 3, barY + 10, color);
        }
        String dimText = this.getDimensionShortName();
        guiGraphics.m_280056_(mc.f_91062_, dimText, 40, 8, this.getDimensionColor(), false);
        String vcText = this.voiceChatAvailable ? "VC" : "!VC";
        guiGraphics.m_280056_(mc.f_91062_, vcText, 70, 8, this.voiceChatAvailable ? -16711936 : -65536, false);
        if (mc.f_91073_ != null) {
            int gameTime = (int)(mc.f_91073_.m_46468_() % 24000L);
            int hours = (gameTime / 1000 + 6) % 24;
            int minutes = (int)((double)(gameTime % 1000) / 16.67);
            String time = String.format("%02d:%02d", hours, minutes);
            guiGraphics.m_280056_(mc.f_91062_, time, 170, 8, -1, false);
        }
        if (mc.f_91074_ != null) {
            int battery = (int)(mc.f_91074_.m_21223_() / mc.f_91074_.m_21233_() * 100.0f);
            int batteryColor = battery > 50 ? -16711936 : (battery > 20 ? -256 : -65536);
            guiGraphics.m_280056_(mc.f_91062_, battery + "%", 135, 8, batteryColor, false);
        }
        if (this.emergencyMode && (blink = System.currentTimeMillis() / 500L % 2L) == 0L) {
            guiGraphics.m_280056_(mc.f_91062_, "SOS", 100, 8, -65536, false);
        }
    }

    private void renderHomeScreenScaled(GuiGraphics guiGraphics, int y) {
        Minecraft mc = Minecraft.m_91087_();
        guiGraphics.m_280137_(mc.f_91062_, "PLANARCELL", 110, y + 10, -16711681);
        String[] icons = new String[]{"Kisiler", "Ara", "Ayarlar", "Internet", "Bilgi"};
        int[] colors = new int[]{-11751600, -14575885, -6543440, -1499549, -26624};
        for (int i = 0; i < icons.length; ++i) {
            boolean selected;
            int row;
            int col;
            if (i < 4) {
                col = i % 2;
                row = i / 2;
            } else {
                col = 0;
                row = 2;
            }
            boolean bl = selected = this.selectedIndex == i;
            if (i == 4) {
                this.drawHomeIconCentered(guiGraphics, y + 50, row, icons[i], colors[i], selected);
                continue;
            }
            this.drawHomeIconScaled(guiGraphics, y + 50, col, row, icons[i], colors[i], selected);
        }
        if (this.heldCallPartner != null) {
            guiGraphics.m_280137_(mc.f_91062_, "[ Bekletilen: " + this.heldCallPartnerName + " ]", 110, y + 230, -22016);
            guiGraphics.m_280137_(mc.f_91062_, "ENTER: Devam et", 110, y + 245, -7829368);
        }
        guiGraphics.m_280137_(mc.f_91062_, "OK ile gezin, ENTER ile secin", 110, y + 290, -10066330);
    }

    private void drawHomeIconCentered(GuiGraphics guiGraphics, int baseY, int row, String label, int color, boolean selected) {
        Minecraft mc = Minecraft.m_91087_();
        int iconSize = 60;
        int spacing = 15;
        int x = (220 - iconSize) / 2;
        int iconY = baseY + row * (iconSize + spacing);
        int bgColor = selected ? -12298906 : -15066578;
        guiGraphics.m_280509_(x, iconY, x + iconSize, iconY + iconSize, bgColor);
        guiGraphics.m_280509_(x, iconY, x + iconSize, iconY + 5, color);
        if (selected) {
            guiGraphics.m_280509_(x - 2, iconY - 2, x + iconSize + 2, iconY, -16711681);
            guiGraphics.m_280509_(x - 2, iconY + iconSize, x + iconSize + 2, iconY + iconSize + 2, -16711681);
            guiGraphics.m_280509_(x - 2, iconY, x, iconY + iconSize, -16711681);
            guiGraphics.m_280509_(x + iconSize, iconY, x + iconSize + 2, iconY + iconSize, -16711681);
        }
        guiGraphics.m_280137_(mc.f_91062_, label, x + iconSize / 2, iconY + iconSize / 2 - 4, -1);
    }

    private void drawHomeIconScaled(GuiGraphics guiGraphics, int y, int col, int row, String label, int color, boolean selected) {
        Minecraft mc = Minecraft.m_91087_();
        int iconX = 30 + col * 90;
        int iconY = y + row * 80;
        int bgColor = selected ? -12303258 : -14540220;
        guiGraphics.m_280509_(iconX, iconY, iconX + 70, iconY + 60, bgColor);
        guiGraphics.m_280509_(iconX + 2, iconY + 2, iconX + 68, iconY + 58, color);
        guiGraphics.m_280137_(mc.f_91062_, label, iconX + 35, iconY + 65, -1);
        if (selected) {
            guiGraphics.m_280509_(iconX - 2, iconY - 2, iconX + 72, iconY, -16711681);
            guiGraphics.m_280509_(iconX - 2, iconY + 60, iconX + 72, iconY + 62, -16711681);
        }
    }

    private void renderContactsScreenScaled(GuiGraphics guiGraphics, int y) {
        Minecraft mc = Minecraft.m_91087_();
        guiGraphics.m_280137_(mc.f_91062_, "KISILER", 110, y + 10, -16711681);
        if (this.contacts.isEmpty()) {
            guiGraphics.m_280137_(mc.f_91062_, "Hicbir oyuncu yok", 110, y + 100, -7829368);
        } else {
            int listY = y + 40;
            for (int i = 0; i < this.contacts.size() && i < 8; ++i) {
                Contact c = this.contacts.get(i);
                boolean selected = this.selectedIndex == i;
                int bgColor = selected ? -13417387 : -15066578;
                guiGraphics.m_280509_(15, listY + i * 30, 205, listY + i * 30 + 28, bgColor);
                int textColor = selected ? -16711681 : -1;
                guiGraphics.m_280056_(mc.f_91062_, c.name, 25, listY + i * 30 + 5, textColor, false);
                guiGraphics.m_280056_(mc.f_91062_, c.number, 25, listY + i * 30 + 15, -7829368, false);
                guiGraphics.m_280509_(195, listY + i * 30 + 10, 200, listY + i * 30 + 18, -16711936);
            }
        }
        guiGraphics.m_280137_(mc.f_91062_, "ESC: Geri | ENTER: Ara", 110, y + 300, -10066330);
    }

    private void renderDialerScreenScaled(GuiGraphics guiGraphics, int y) {
        Minecraft mc = Minecraft.m_91087_();
        guiGraphics.m_280137_(mc.f_91062_, "NUMARA CEVIRICI", 110, y + 10, -16711681);
        String displayNumber = this.dialedNumber.isEmpty() ? "___-___-____" : this.dialedNumber;
        guiGraphics.m_280137_(mc.f_91062_, displayNumber, 110, y + 50, -1);
        String[] keys = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "0", "#"};
        for (int i = 0; i < 12; ++i) {
            int col = i % 3;
            int row = i / 3;
            int kx = 40 + col * 50;
            int ky = y + 80 + row * 45;
            boolean selected = this.selectedIndex == i;
            int bgColor = selected ? -12298906 : -14013874;
            guiGraphics.m_280509_(kx, ky, kx + 40, ky + 35, bgColor);
            guiGraphics.m_280137_(mc.f_91062_, keys[i], kx + 20, ky + 13, -1);
        }
        int callY = y + 270;
        boolean callSelected = this.selectedIndex == 12;
        guiGraphics.m_280509_(60, callY, 160, callY + 35, callSelected ? -16733696 : -16711936);
        guiGraphics.m_280137_(mc.f_91062_, "ARA", 110, callY + 13, -1);
        guiGraphics.m_280137_(mc.f_91062_, "ESC: Geri | BACKSPACE: Sil", 110, y + 320, -10066330);
    }

    private void renderSettingsScreenScaled(GuiGraphics guiGraphics, int y) {
        Minecraft mc = Minecraft.m_91087_();
        guiGraphics.m_280137_(mc.f_91062_, "AYARLAR", 110, y + 10, -16711681);
        String ringtoneName = this.selectedRingtone == 0 ? "Zil Sesi 1" : "Zil Sesi 2";
        String[] options = new String[]{"GUI Boyutu: " + this.getCurrentScaleLabel(), "Ses Seviyesi: %" + this.volumeLevel, "Titresim: " + (this.vibrationEnabled ? "Acik" : "Kapali"), "Bildirimler: " + (this.notificationsEnabled ? "Acik" : "Kapali"), "Zil Sesi: " + ringtoneName, "Ses Testi & Simulasyon", "Hakkinda"};
        int listY = y + 45;
        for (int i = 0; i < options.length; ++i) {
            boolean selected = this.selectedIndex == i;
            int bgColor = selected ? -13417387 : -15066578;
            guiGraphics.m_280509_(15, listY + i * 32, 205, listY + i * 32 + 29, bgColor);
            guiGraphics.m_280056_(mc.f_91062_, options[i], 25, listY + i * 32 + 10, -1, false);
            if (!selected) continue;
            if (i == 0) {
                guiGraphics.m_280056_(mc.f_91062_, "<", 160, listY + i * 32 + 10, -16711681, false);
                guiGraphics.m_280056_(mc.f_91062_, ">", 190, listY + i * 32 + 10, -16711681, false);
            }
            if (i == 1) {
                guiGraphics.m_280056_(mc.f_91062_, "<", 160, listY + i * 32 + 10, -16711681, false);
                guiGraphics.m_280056_(mc.f_91062_, ">", 190, listY + i * 32 + 10, -16711681, false);
            }
            if (i == 2 || i == 3) {
                guiGraphics.m_280056_(mc.f_91062_, "< >", 160, listY + i * 32 + 10, -16711681, false);
            }
            if (i != 4) continue;
            guiGraphics.m_280056_(mc.f_91062_, "<", 160, listY + i * 32 + 10, -16711681, false);
            guiGraphics.m_280056_(mc.f_91062_, ">", 190, listY + i * 32 + 10, -16711681, false);
        }
        guiGraphics.m_280137_(mc.f_91062_, "SOL-SAG: Ayarla | ESC: Geri", 110, y + 290, -10066330);
    }

    private void renderIncomingCallScreenScaled(GuiGraphics guiGraphics, int y) {
        Minecraft mc = Minecraft.m_91087_();
        long pulse = System.currentTimeMillis() / 500L % 2L;
        int bgColor = pulse == 0L ? -15058406 : -15066578;
        guiGraphics.m_280509_(8, y, 212, y + 300, bgColor);
        guiGraphics.m_280137_(mc.f_91062_, "GELEN CAGRI", 110, y + 30, -16711936);
        guiGraphics.m_280137_(mc.f_91062_, this.incomingCallerName, 110, y + 80, -1);
        guiGraphics.m_280509_(80, y + 100, 140, y + 160, -12303292);
        if (!this.incomingCallerName.isEmpty()) {
            guiGraphics.m_280137_(mc.f_91062_, this.incomingCallerName.substring(0, 1).toUpperCase(), 110, y + 125, -1);
        }
        boolean acceptSelected = this.selectedIndex == 0;
        boolean rejectSelected = this.selectedIndex == 1;
        guiGraphics.m_280509_(30, y + 200, 100, y + 240, acceptSelected ? -16733696 : -16711936);
        guiGraphics.m_280137_(mc.f_91062_, "KABUL", 65, y + 215, -1);
        guiGraphics.m_280509_(120, y + 200, 190, y + 240, rejectSelected ? -5636096 : -65536);
        guiGraphics.m_280137_(mc.f_91062_, "REDDET", 155, y + 215, -1);
        guiGraphics.m_280137_(mc.f_91062_, "OK ile sec, ENTER ile onayla", 110, y + 280, -10066330);
    }

    private void renderOutgoingCallScreenScaled(GuiGraphics guiGraphics, int y) {
        Minecraft mc = Minecraft.m_91087_();
        guiGraphics.m_280137_(mc.f_91062_, "ARANIYOR...", 110, y + 30, -14575885);
        guiGraphics.m_280137_(mc.f_91062_, this.currentCallPartnerName, 110, y + 80, -1);
        if (this.currentCallPartnerName.contains("mesgul")) {
            guiGraphics.m_280137_(mc.f_91062_, "Kullanici mesgul.", 110, y + 120, -22016);
            guiGraphics.m_280137_(mc.f_91062_, "Baglanmak icin bekleyin", 110, y + 135, -22016);
            guiGraphics.m_280137_(mc.f_91062_, "ya da daha sonra tekrar deneyin.", 110, y + 150, -22016);
        }
        long dots = System.currentTimeMillis() / 500L % 4L;
        String dotStr = ".".repeat((int)dots);
        guiGraphics.m_280137_(mc.f_91062_, dotStr, 110, y + 180, -7829368);
        guiGraphics.m_280509_(60, y + 220, 160, y + 260, -65536);
        guiGraphics.m_280137_(mc.f_91062_, "IPTAL", 110, y + 235, -1);
        guiGraphics.m_280137_(mc.f_91062_, "ENTER: Iptal Et", 110, y + 280, -10066330);
    }

    private void renderActiveCallScreenScaled(GuiGraphics guiGraphics, int y) {
        Minecraft mc = Minecraft.m_91087_();
        guiGraphics.m_280509_(8, y, 212, y + 50, -16733696);
        guiGraphics.m_280137_(mc.f_91062_, "AKTIF GORUSME", 110, y + 10, -1);
        long duration = (System.currentTimeMillis() - this.callStartTime) / 1000L;
        String durationStr = String.format("%02d:%02d", duration / 60L, duration % 60L);
        guiGraphics.m_280137_(mc.f_91062_, durationStr, 110, y + 30, -1);
        guiGraphics.m_280137_(mc.f_91062_, this.currentCallPartnerName, 110, y + 80, -1);
        guiGraphics.m_280509_(80, y + 100, 140, y + 160, -12303292);
        guiGraphics.m_280137_(mc.f_91062_, this.currentCallPartnerName.isEmpty() ? "?" : this.currentCallPartnerName.substring(0, 1).toUpperCase(), 110, y + 125, -1);
        if (this.signalStrength < 30) {
            guiGraphics.m_280137_(mc.f_91062_, "! Dusuk sinyal !", 110, y + 170, -39424);
        }
        int buttonY = y + 200;
        boolean holdSelected = this.selectedIndex == 0;
        guiGraphics.m_280509_(20, buttonY, 100, buttonY + 35, holdSelected ? -10066432 : -5592576);
        guiGraphics.m_280137_(mc.f_91062_, "BEKLET", 60, buttonY + 13, -1);
        boolean endSelected = this.selectedIndex == 1;
        guiGraphics.m_280509_(120, buttonY, 200, buttonY + 35, endSelected ? -5636096 : -65536);
        guiGraphics.m_280137_(mc.f_91062_, "KAPAT", 160, buttonY + 13, -1);
        if (this.heldCallPartner != null) {
            guiGraphics.m_280137_(mc.f_91062_, "Bekletilen: " + this.heldCallPartnerName, 110, buttonY + 50, -22016);
        }
        guiGraphics.m_280137_(mc.f_91062_, "OK ile sec, ENTER ile onayla", 110, y + 290, -10066330);
    }

    private void renderEmergencyScreenScaled(GuiGraphics guiGraphics, int y) {
        Minecraft mc = Minecraft.m_91087_();
        long pulse = System.currentTimeMillis() / 300L % 2L;
        int bgColor = pulse == 0L ? -12969446 : -14020592;
        guiGraphics.m_280509_(8, y, 212, y + 320, bgColor);
        guiGraphics.m_280137_(mc.f_91062_, "! ACIL DURUM MODU !", 110, y + 20, -65536);
        guiGraphics.m_280137_(mc.f_91062_, "Sinyal Kaybi", 110, y + 40, -39322);
        int compassCenterX = 110;
        int compassCenterY = y + 120;
        int compassRadius = 50;
        guiGraphics.m_280509_(compassCenterX - compassRadius, compassCenterY - compassRadius, compassCenterX + compassRadius, compassCenterY + compassRadius, -15066578);
        float displayDirection = this.isGlitching ? this.glitchDirection : this.directionToNearest;
        double displayDistance = this.isGlitching ? this.glitchDistance : this.distanceToNearest;
        float playerYaw = mc.f_91074_ != null ? mc.f_91074_.m_146908_() : 0.0f;
        float relativeDirection = displayDirection - playerYaw + 90.0f;
        double arrowX = (double)compassCenterX + Math.cos(Math.toRadians(relativeDirection)) * 35.0;
        double arrowY = (double)compassCenterY + Math.sin(Math.toRadians(relativeDirection)) * 35.0;
        int arrowColor = this.isGlitching ? -65281 : -16711936;
        guiGraphics.m_280509_((int)arrowX - 5, (int)arrowY - 5, (int)arrowX + 5, (int)arrowY + 5, arrowColor);
        guiGraphics.m_280137_(mc.f_91062_, "N", compassCenterX, compassCenterY - compassRadius - 10, -1);
        String distanceText = this.isGlitching ? String.format("%.0f m ???", displayDistance) : String.format("%.0f m", displayDistance);
        guiGraphics.m_280137_(mc.f_91062_, "Mesafe: " + distanceText, 110, y + 190, this.isGlitching ? -65281 : -1);
        String dirText = this.getCardinalDirection(displayDirection);
        guiGraphics.m_280137_(mc.f_91062_, "Yon: " + dirText, 110, y + 210, this.isGlitching ? -65281 : -1);
        if (this.isNether()) {
            guiGraphics.m_280137_(mc.f_91062_, "| NETHER PARAZITI |", 110, y + 240, -48060);
            if (this.isGlitching) {
                guiGraphics.m_280137_(mc.f_91062_, "~~~HATA~~~", 110, y + 255, -65281);
            }
        }
        if (this.stationBroken) {
            guiGraphics.m_280137_(mc.f_91062_, "En yakin istasyon ARIZALI", 110, y + 270, -65536);
        }
        guiGraphics.m_280137_(mc.f_91062_, "Baz istasyonu arayin!", 110, y + 300, -7829368);
    }

    private void startTestCall(int scenario) {
        this.isInTestMode = true;
        this.testScenario = scenario;
        this.currentMenu = 6;
        this.currentCallPartnerName = "Ses Testi";
        this.callStartTime = System.currentTimeMillis();
        this.selectedIndex = 1;
        this.playRingtone();
    }

    private void renderTestSelectionScreenScaled(GuiGraphics guiGraphics, int y) {
        Minecraft mc = Minecraft.m_91087_();
        guiGraphics.m_280137_(mc.f_91062_, "SES TESTI", 110, y + 10, -16711681);
        String[] options = new String[]{"Normal (Overworld)", "Parazitli (Nether)", "Uzak Mesafe (End)"};
        int listY = y + 60;
        for (int i = 0; i < options.length; ++i) {
            boolean selected = this.selectedIndex == i;
            int bgColor = selected ? -13417387 : -15066578;
            guiGraphics.m_280509_(15, listY + i * 40, 205, listY + i * 40 + 35, bgColor);
            guiGraphics.m_280137_(mc.f_91062_, options[i], 110, listY + i * 40 + 13, -1);
        }
        guiGraphics.m_280137_(mc.f_91062_, "Bu test sadece GORSEL sim\u00fclasyondur.", 110, y + 200, -22016);
        guiGraphics.m_280137_(mc.f_91062_, "Kendi sesinizi duymak icin:", 110, y + 220, -5592406);
        guiGraphics.m_280137_(mc.f_91062_, "'V' > Ayarlar > Mikrofon Test", 110, y + 235, -1);
        guiGraphics.m_280137_(mc.f_91062_, "Gorusme testi: 2. hesapla girin", 110, y + 260, -5592406);
        guiGraphics.m_280137_(mc.f_91062_, "ve kendinizi arayin.", 110, y + 275, -5592406);
        guiGraphics.m_280137_(mc.f_91062_, "ESC: Geri", 110, y + 300, -10066330);
    }

    private void renderWaitingCallScreenScaled(GuiGraphics guiGraphics, int y) {
        Minecraft mc = Minecraft.m_91087_();
        guiGraphics.m_280509_(8, y, 212, y + 40, -16733696);
        guiGraphics.m_280137_(mc.f_91062_, "Aktif: " + this.currentCallPartnerName, 110, y + 15, -1);
        guiGraphics.m_280509_(8, y + 50, 212, y + 200, -12961254);
        guiGraphics.m_280137_(mc.f_91062_, "BEKLEYEN CAGRI", 110, y + 60, -22016);
        if (!this.waitingCalls.isEmpty()) {
            WaitingCallInfo waiting = this.waitingCalls.get(0);
            guiGraphics.m_280137_(mc.f_91062_, waiting.callerName, 110, y + 90, -1);
            boolean acceptSelected = this.selectedIndex == 0;
            guiGraphics.m_280509_(20, y + 120, 100, y + 155, acceptSelected ? -16733696 : -16711936);
            guiGraphics.m_280137_(mc.f_91062_, "YANITLA", 60, y + 132, -1);
            boolean rejectSelected = this.selectedIndex == 1;
            guiGraphics.m_280509_(120, y + 120, 200, y + 155, rejectSelected ? -5636096 : -65536);
            guiGraphics.m_280137_(mc.f_91062_, "REDDET", 160, y + 132, -1);
            guiGraphics.m_280137_(mc.f_91062_, "(Mevcut cagri bekletilecek)", 110, y + 175, -7829368);
        }
        guiGraphics.m_280137_(mc.f_91062_, "OK ile sec, ENTER ile onayla", 110, y + 290, -10066330);
    }

    private void renderHeldCallIndicatorScaled(GuiGraphics guiGraphics, int y) {
        Minecraft mc = Minecraft.m_91087_();
        guiGraphics.m_280509_(8, y, 212, y + 30, -5592576);
        guiGraphics.m_280137_(mc.f_91062_, "Bekletilen: " + this.heldCallPartnerName, 110, y + 10, -1);
    }

    private void renderInfoScreenScaled(GuiGraphics guiGraphics, int y) {
        String signalText;
        Minecraft mc = Minecraft.m_91087_();
        guiGraphics.m_280137_(mc.f_91062_, "BILGI", 110, y + 10, -16711681);
        int infoY = y + 40;
        int lineHeight = 18;
        guiGraphics.m_280056_(mc.f_91062_, "Mod: Planarcell v1.1-b", 20, infoY, -1, false);
        guiGraphics.m_280056_(mc.f_91062_, "Numaram: " + this.myNumber, 20, infoY += lineHeight, -16711936, false);
        guiGraphics.m_280056_(mc.f_91062_, "Gelistirici: planarminds. | BerkeB0i", 20, infoY += lineHeight + 5, -7829368, false);
        guiGraphics.m_280509_(15, infoY += lineHeight + 10, 205, infoY + 80, -15066578);
        guiGraphics.m_280056_(mc.f_91062_, "Sinyal Durumu:", 20, infoY += 5, -16711681, false);
        String string = signalText = this.hasSignal ? this.signalStrength + "%" : "YOK";
        int signalColor = this.hasSignal ? (this.signalStrength > 50 ? -16711936 : -256) : -65536;
        guiGraphics.m_280056_(mc.f_91062_, "  Guc: " + signalText, 20, infoY += lineHeight, signalColor, false);
        infoY += lineHeight;
        String dimName = "Overworld";
        if (this.currentDimension.contains("nether")) {
            dimName = "Nether";
        } else if (this.currentDimension.contains("end")) {
            dimName = "End";
        }
        guiGraphics.m_280056_(mc.f_91062_, "  Boyut: " + dimName, 20, infoY, -1, false);
        infoY += lineHeight;
        if (this.emergencyMode) {
            guiGraphics.m_280056_(mc.f_91062_, "  ACIL DURUM MODU AKTIF", 20, infoY, -65536, false);
        } else if (this.stationBroken) {
            guiGraphics.m_280056_(mc.f_91062_, "  Istasyon arizali!", 20, infoY, -22016, false);
        }
        guiGraphics.m_280056_(mc.f_91062_, "Voice Chat Ayarlari:", 20, infoY += lineHeight + 15, -16711681, false);
        String vcStatus = this.voiceChatAvailable ? "Aktif" : "Yuklenmedi";
        int vcColor = this.voiceChatAvailable ? -16711936 : -39424;
        guiGraphics.m_280056_(mc.f_91062_, "  Durum: " + vcStatus, 20, infoY += lineHeight, vcColor, false);
        guiGraphics.m_280056_(mc.f_91062_, "  Mikrofon/Hoparlor icin:", 20, infoY += lineHeight, -5592406, false);
        guiGraphics.m_280056_(mc.f_91062_, "  'V' tusuna basin", 20, infoY += lineHeight, -1, false);
        infoY += lineHeight + 15;
        guiGraphics.m_280137_(mc.f_91062_, "Planarcell 2025", 110, y + 280, -12303292);
        guiGraphics.m_280137_(mc.f_91062_, "ESC: Geri", 110, y + 310, -10066330);
    }

    private void renderStaticNoiseScaled(GuiGraphics guiGraphics) {
        Random r = new Random();
        for (int i = 0; i < 500; ++i) {
            int px = 8 + r.nextInt(204);
            int py = 25 + r.nextInt(360);
            int gray = r.nextInt(100);
            guiGraphics.m_280509_(px, py, px + 1, py + 1, Integer.MIN_VALUE | gray << 16 | gray << 8 | gray);
        }
    }

    private int getSignalColor() {
        if (!this.hasSignal) {
            return -65536;
        }
        if (this.signalStrength > 60) {
            return -16711936;
        }
        if (this.signalStrength > 30) {
            return -256;
        }
        return -39424;
    }

    private String getDimensionShortName() {
        if (this.isInTestMode) {
            if (this.testScenario == 1) {
                return "NET";
            }
            if (this.testScenario == 2) {
                return "END";
            }
            return "OW";
        }
        if (this.currentDimension.contains("nether")) {
            return "NET";
        }
        if (this.currentDimension.contains("end")) {
            return "END";
        }
        return "OW";
    }

    private int getDimensionColor() {
        if (this.isInTestMode) {
            if (this.testScenario == 1) {
                return -48060;
            }
            if (this.testScenario == 2) {
                return -5635841;
            }
            return -12255420;
        }
        if (this.currentDimension.contains("nether")) {
            return -48060;
        }
        if (this.currentDimension.contains("end")) {
            return -5635841;
        }
        return -12255420;
    }

    private boolean isNether() {
        if (this.isInTestMode && this.testScenario == 1) {
            return true;
        }
        return this.currentDimension.contains("nether");
    }

    private void updateGlitchEffect() {
        long now = System.currentTimeMillis();
        if (!this.isGlitching && now - this.lastGlitchTime > (long)(2000 + this.glitchRandom.nextInt(8000))) {
            this.isGlitching = true;
            this.lastGlitchTime = now;
            this.glitchDirection = this.glitchRandom.nextFloat() * 360.0f;
            this.glitchDistance = this.glitchRandom.nextDouble() * 9999.0;
        }
        if (this.isGlitching && now - this.lastGlitchTime > 500L) {
            this.isGlitching = false;
        }
    }

    private String getCardinalDirection(float angle) {
        if ((double)(angle = (angle + 360.0f) % 360.0f) < 22.5 || (double)angle >= 337.5) {
            return "D (Dogu)";
        }
        if ((double)angle < 67.5) {
            return "GD (Guney-Dogu)";
        }
        if ((double)angle < 112.5) {
            return "G (Guney)";
        }
        if ((double)angle < 157.5) {
            return "GB (Guney-Bati)";
        }
        if ((double)angle < 202.5) {
            return "B (Bati)";
        }
        if ((double)angle < 247.5) {
            return "KB (Kuzey-Bati)";
        }
        if ((double)angle < 292.5) {
            return "K (Kuzey)";
        }
        return "KD (Kuzey-Dogu)";
    }

    public boolean handleInput(int keyCode) {
        switch (this.currentMenu) {
            case 0: {
                return this.handleHomeInput(keyCode);
            }
            case 1: {
                return this.handleContactsInput(keyCode);
            }
            case 2: {
                return this.handleDialerInput(keyCode);
            }
            case 3: {
                return this.handleSettingsInput(keyCode);
            }
            case 4: {
                return this.handleIncomingCallInput(keyCode);
            }
            case 5: {
                return this.handleOutgoingCallInput(keyCode);
            }
            case 6: {
                return this.handleActiveCallInput(keyCode);
            }
            case 8: {
                return this.handleWaitingCallInput(keyCode);
            }
            case 7: {
                return this.handleEmergencyInput(keyCode);
            }
            case 9: {
                return this.handleInfoInput(keyCode);
            }
            case 10: {
                return this.handleTestSelectionInput(keyCode);
            }
        }
        return false;
    }

    private boolean handleTestSelectionInput(int key) {
        if (key == 256) {
            this.currentMenu = 3;
            this.selectedIndex = 4;
            this.playClick();
            return true;
        }
        if (key == 265) {
            this.selectedIndex = Math.max(0, this.selectedIndex - 1);
            this.playClick();
            return true;
        }
        if (key == 264) {
            this.selectedIndex = Math.min(2, this.selectedIndex + 1);
            this.playClick();
            return true;
        }
        if (key == 257) {
            this.startTestCall(this.selectedIndex);
            this.playClick();
            return true;
        }
        return false;
    }

    private boolean handleHomeInput(int key) {
        if (key == 263) {
            if (this.selectedIndex == 1) {
                this.selectedIndex = 0;
            } else if (this.selectedIndex == 3) {
                this.selectedIndex = 2;
            }
            this.playClick();
            return true;
        }
        if (key == 262) {
            if (this.selectedIndex == 0) {
                this.selectedIndex = 1;
            } else if (this.selectedIndex == 2) {
                this.selectedIndex = 3;
            }
            this.playClick();
            return true;
        }
        if (key == 265) {
            if (this.selectedIndex == 2) {
                this.selectedIndex = 0;
            } else if (this.selectedIndex == 3) {
                this.selectedIndex = 1;
            } else if (this.selectedIndex == 4) {
                this.selectedIndex = 2;
            }
            this.playClick();
            return true;
        }
        if (key == 264) {
            if (this.selectedIndex == 0) {
                this.selectedIndex = 2;
            } else if (this.selectedIndex == 1) {
                this.selectedIndex = 3;
            } else if (this.selectedIndex == 2 || this.selectedIndex == 3) {
                this.selectedIndex = 4;
            }
            this.playClick();
            return true;
        }
        if (key == 257) {
            this.playClick();
            if (this.heldCallPartner != null && this.selectedIndex == -1) {
                this.resumeHeldCall();
                return true;
            }
            switch (this.selectedIndex) {
                case 0: {
                    this.currentMenu = 1;
                    this.selectedIndex = 0;
                    this.updateContacts();
                    break;
                }
                case 1: {
                    this.currentMenu = 2;
                    this.selectedIndex = 0;
                    this.dialedNumber = "";
                    break;
                }
                case 2: {
                    this.currentMenu = 3;
                    this.selectedIndex = 0;
                    break;
                }
                case 3: {
                    this.openBrowser();
                    break;
                }
                case 4: {
                    this.currentMenu = 9;
                    this.selectedIndex = 0;
                }
            }
            return true;
        }
        return false;
    }

    private void openBrowser() {
        try {
            if (PhoneBrowserScreen.isBrowserAvailable()) {
                Minecraft.m_91087_().m_91152_((Screen)new PhoneBrowserScreen());
            } else {
                System.out.println("[Planarcell] Browser unavailable - MCEF not installed");
            }
        }
        catch (NoClassDefFoundError e) {
            System.out.println("[Planarcell] MCEF not found: " + e.getMessage());
        }
    }

    private boolean handleContactsInput(int key) {
        if (key == 256) {
            this.currentMenu = 0;
            this.selectedIndex = 0;
            this.playClick();
            return true;
        }
        if (key == 265) {
            this.selectedIndex = Math.max(0, this.selectedIndex - 1);
            this.playClick();
            return true;
        }
        if (key == 264) {
            this.selectedIndex = Math.min(this.contacts.size() - 1, this.selectedIndex + 1);
            this.playClick();
            return true;
        }
        if (key == 257 && !this.contacts.isEmpty()) {
            Contact c = this.contacts.get(this.selectedIndex);
            this.initiateCall(c.uuid, c.name);
            return true;
        }
        return false;
    }

    private boolean handleDialerInput(int key) {
        if (key == 256) {
            this.currentMenu = 0;
            this.selectedIndex = 0;
            this.dialedNumber = "";
            this.playClick();
            return true;
        }
        if (key == 259 && !this.dialedNumber.isEmpty()) {
            this.dialedNumber = this.dialedNumber.substring(0, this.dialedNumber.length() - 1);
            this.playClick();
            return true;
        }
        if (key >= 48 && key <= 57) {
            if (this.dialedNumber.length() < 12) {
                this.dialedNumber = this.dialedNumber + (char)(48 + key - 48);
                this.playClick();
            }
            return true;
        }
        if (key >= 320 && key <= 329) {
            if (this.dialedNumber.length() < 12) {
                this.dialedNumber = this.dialedNumber + (char)(48 + key - 320);
                this.playClick();
            }
            return true;
        }
        if (key == 257 || key == 335) {
            if (this.selectedIndex >= 0 && this.selectedIndex < 12) {
                String[] keys = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "0", "#"};
                if (this.dialedNumber.length() < 12) {
                    this.dialedNumber = this.dialedNumber + keys[this.selectedIndex];
                    this.playClick();
                }
            } else if (this.selectedIndex == 12 && !this.dialedNumber.isEmpty()) {
                if (this.dialedNumber.equals(this.myNumber) || this.dialedNumber.equals("999")) {
                    this.currentMenu = 10;
                    this.selectedIndex = 0;
                    this.playClick();
                    return true;
                }
                this.dialByNumber(this.dialedNumber);
            }
            return true;
        }
        if (key == 265) {
            if (this.selectedIndex >= 3) {
                this.selectedIndex -= 3;
            }
            this.playClick();
            return true;
        }
        if (key == 264) {
            if (this.selectedIndex < 12) {
                this.selectedIndex = Math.min(12, this.selectedIndex + 3);
            }
            this.playClick();
            return true;
        }
        if (key == 263) {
            if (this.selectedIndex > 0 && this.selectedIndex <= 12) {
                --this.selectedIndex;
            }
            this.playClick();
            return true;
        }
        if (key == 262) {
            if (this.selectedIndex < 12) {
                ++this.selectedIndex;
            }
            this.playClick();
            return true;
        }
        return false;
    }

    private boolean handleSettingsInput(int key) {
        if (key == 256) {
            this.currentMenu = 0;
            this.selectedIndex = 0;
            this.playClick();
            return true;
        }
        if (key == 265) {
            this.selectedIndex = Math.max(0, this.selectedIndex - 1);
            this.playClick();
            return true;
        }
        if (key == 264) {
            this.selectedIndex = Math.min(6, this.selectedIndex + 1);
            this.playClick();
            return true;
        }
        switch (this.selectedIndex) {
            case 0: {
                if (key == 263) {
                    this.decreaseScale();
                    return true;
                }
                if (key != 262) break;
                this.increaseScale();
                return true;
            }
            case 1: {
                if (key == 257) {
                    this.playTestSound();
                    return true;
                }
                if (key == 263) {
                    this.volumeLevel = Math.max(0, this.volumeLevel - 10);
                    this.playClick();
                    return true;
                }
                if (key != 262) break;
                this.volumeLevel = Math.min(100, this.volumeLevel + 10);
                this.playClick();
                return true;
            }
            case 2: {
                if (key != 257 && key != 263 && key != 262) break;
                this.vibrationEnabled = !this.vibrationEnabled;
                this.playTestSound();
                return true;
            }
            case 3: {
                if (key != 257 && key != 263 && key != 262) break;
                this.notificationsEnabled = !this.notificationsEnabled;
                this.playTestSound();
                return true;
            }
            case 4: {
                if (key == 263 || key == 262) {
                    this.selectedRingtone = (this.selectedRingtone + 1) % 2;
                    this.playRingtone();
                    return true;
                }
                if (key != 257) break;
                this.playRingtone();
                return true;
            }
            case 5: {
                if (key != 257) break;
                this.currentMenu = 10;
                this.selectedIndex = 0;
                this.playClick();
                return true;
            }
            case 6: {
                if (key != 257) break;
                this.currentMenu = 9;
                this.selectedIndex = 0;
                this.playClick();
                return true;
            }
        }
        return false;
    }

    private boolean handleInfoInput(int key) {
        if (key == 256) {
            this.currentMenu = 0;
            this.selectedIndex = 0;
            this.playClick();
            return true;
        }
        return false;
    }

    private boolean handleIncomingCallInput(int key) {
        if (key == 263 || key == 262) {
            this.selectedIndex = 1 - this.selectedIndex;
            this.playClick();
            return true;
        }
        if (key == 257) {
            if (this.selectedIndex == 0) {
                this.acceptIncomingCall();
            } else {
                this.rejectIncomingCall();
            }
            return true;
        }
        return false;
    }

    private boolean handleOutgoingCallInput(int key) {
        if (key == 257 || key == 256) {
            this.endCurrentCall();
            this.currentMenu = 0;
            this.selectedIndex = 0;
            return true;
        }
        return false;
    }

    private boolean handleActiveCallInput(int key) {
        if (key == 263 || key == 262) {
            this.selectedIndex = 1 - this.selectedIndex;
            this.playClick();
            return true;
        }
        if (key == 257) {
            if (this.selectedIndex == 0) {
                this.holdCurrentCall();
            } else {
                this.endCurrentCall();
            }
            return true;
        }
        return false;
    }

    private boolean handleWaitingCallInput(int key) {
        if (key == 263 || key == 262) {
            this.selectedIndex = 1 - this.selectedIndex;
            this.playClick();
            return true;
        }
        if (key == 257 && !this.waitingCalls.isEmpty()) {
            WaitingCallInfo waiting = this.waitingCalls.get(0);
            if (this.selectedIndex == 0) {
                this.acceptWaitingCall(waiting);
            } else {
                this.rejectWaitingCall(waiting);
            }
            return true;
        }
        if (key == 256) {
            this.currentMenu = 6;
            this.selectedIndex = 0;
            return true;
        }
        return false;
    }

    private boolean handleEmergencyInput(int key) {
        if (key == 256) {
            this.currentMenu = 0;
            this.selectedIndex = 0;
            return true;
        }
        return false;
    }

    private void playClick() {
        if (this.volumeLevel > 0) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.m_203334_()), (float)1.0f, (float)((float)this.volumeLevel / 100.0f)));
        }
    }

    private void playRingtone() {
        if (this.notificationsEnabled) {
            if (this.volumeLevel > 0) {
                SoundEvent ringtoneSound = this.selectedRingtone == 1 ? (SoundEvent)ModSounds.RINGTONE2.get() : (SoundEvent)ModSounds.RINGTONE1.get();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)ringtoneSound, (float)1.0f, (float)((float)this.volumeLevel / 100.0f)));
            }
            if (this.vibrationEnabled) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12209_.m_203334_()), (float)0.5f, (float)0.5f));
            }
        }
    }

    private void playDialSound() {
        if (this.volumeLevel > 0) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12214_.m_203334_()), (float)0.5f, (float)((float)this.volumeLevel / 100.0f)));
        }
    }

    private void playBusySound() {
        if (this.volumeLevel > 0) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12209_.m_203334_()), (float)0.5f, (float)((float)this.volumeLevel / 100.0f)));
        }
    }

    private void playConnectSound() {
        if (this.volumeLevel > 0) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12275_, (float)0.5f, (float)((float)this.volumeLevel / 100.0f)));
        }
    }

    private void playEndSound() {
        if (this.volumeLevel > 0) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.m_203334_()), (float)0.5f, (float)((float)this.volumeLevel / 100.0f)));
        }
    }

    private void playTestSound() {
        if (this.volumeLevel > 0) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12210_.m_203334_()), (float)1.0f, (float)((float)this.volumeLevel / 100.0f)));
            if (this.vibrationEnabled) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12209_.m_203334_()), (float)0.5f, (float)0.5f));
            }
        }
    }

    public static class Contact {
        public String name;
        public String number;
        public UUID uuid;

        public Contact(String name, String number, UUID uuid) {
            this.name = name;
            this.number = number;
            this.uuid = uuid;
        }
    }

    public static class WaitingCallInfo {
        public UUID callerUUID;
        public String callerName;
        public long startTime;

        public WaitingCallInfo(UUID uuid, String name) {
            this.callerUUID = uuid;
            this.callerName = name;
            this.startTime = System.currentTimeMillis();
        }
    }
}

