/*
 * Decompiled with CFR 0.152.
 */
package com.retro.planar.client;

import com.retro.planar.client.gui.HUDPhoneRenderer;
import com.retro.planar.client.input.KeyInit;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ClientSetup {
    public static void init(IEventBus modEventBus) {
        modEventBus.addListener(ClientSetup::registerKeys);
        modEventBus.addListener(ClientSetup::registerOverlays);
    }

    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(KeyInit.OPEN_PHONE_KEY);
        event.register(KeyInit.BACK_KEY);
    }

    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.CHAT_PANEL.id(), "planar_phone", (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> HUDPhoneRenderer.getInstance().render(guiGraphics, screenWidth, screenHeight));
    }

    @Mod.EventBusSubscriber(modid="planarcell", value={Dist.CLIENT})
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            if (KeyInit.OPEN_PHONE_KEY.m_90859_()) {
                HUDPhoneRenderer.getInstance().toggle();
            }
            if (KeyInit.BACK_KEY.m_90859_() && HUDPhoneRenderer.getInstance().isOpen) {
                HUDPhoneRenderer.getInstance().handleBackKey();
            }
            if (HUDPhoneRenderer.getInstance().isOpen && event.getAction() == 1) {
                HUDPhoneRenderer.getInstance().handleInput(event.getKey());
            }
        }
    }
}

